package zio.aws.fms.model
import scala.jdk.CollectionConverters._
sealed trait TargetType {
  def unwrap: software.amazon.awssdk.services.fms.model.TargetType
}
object TargetType {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.TargetType
  ): zio.aws.fms.model.TargetType = value match {
    case software.amazon.awssdk.services.fms.model.TargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.TargetType.GATEWAY =>
      val r = GATEWAY
      r
    case software.amazon.awssdk.services.fms.model.TargetType.CARRIER_GATEWAY =>
      val r = CARRIER_GATEWAY
      r
    case software.amazon.awssdk.services.fms.model.TargetType.INSTANCE =>
      val r = INSTANCE
      r
    case software.amazon.awssdk.services.fms.model.TargetType.LOCAL_GATEWAY =>
      val r = LOCAL_GATEWAY
      r
    case software.amazon.awssdk.services.fms.model.TargetType.NAT_GATEWAY =>
      val r = NAT_GATEWAY
      r
    case software.amazon.awssdk.services.fms.model.TargetType.NETWORK_INTERFACE =>
      val r = NETWORK_INTERFACE
      r
    case software.amazon.awssdk.services.fms.model.TargetType.VPC_ENDPOINT =>
      val r = VPC_ENDPOINT
      r
    case software.amazon.awssdk.services.fms.model.TargetType.VPC_PEERING_CONNECTION =>
      val r = VPC_PEERING_CONNECTION
      r
    case software.amazon.awssdk.services.fms.model.TargetType.EGRESS_ONLY_INTERNET_GATEWAY =>
      val r = EGRESS_ONLY_INTERNET_GATEWAY
      r
    case software.amazon.awssdk.services.fms.model.TargetType.TRANSIT_GATEWAY =>
      val r = TRANSIT_GATEWAY
      r
  }
  case object unknownToSdkVersion extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object GATEWAY extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.GATEWAY
  }
  case object CARRIER_GATEWAY extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.CARRIER_GATEWAY
  }
  case object INSTANCE extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.INSTANCE
  }
  case object LOCAL_GATEWAY extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.LOCAL_GATEWAY
  }
  case object NAT_GATEWAY extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.NAT_GATEWAY
  }
  case object NETWORK_INTERFACE extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.NETWORK_INTERFACE
  }
  case object VPC_ENDPOINT extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.VPC_ENDPOINT
  }
  case object VPC_PEERING_CONNECTION extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.VPC_PEERING_CONNECTION
  }
  case object EGRESS_ONLY_INTERNET_GATEWAY
      extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.EGRESS_ONLY_INTERNET_GATEWAY
  }
  case object TRANSIT_GATEWAY extends zio.aws.fms.model.TargetType {
    override def unwrap: software.amazon.awssdk.services.fms.model.TargetType =
      software.amazon.awssdk.services.fms.model.TargetType.TRANSIT_GATEWAY
  }
}
