package zio.aws.fms.model
import scala.jdk.CollectionConverters._
sealed trait ThirdPartyFirewall {
  def unwrap: software.amazon.awssdk.services.fms.model.ThirdPartyFirewall
}
object ThirdPartyFirewall {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.ThirdPartyFirewall
  ): zio.aws.fms.model.ThirdPartyFirewall = value match {
    case software.amazon.awssdk.services.fms.model.ThirdPartyFirewall.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.ThirdPartyFirewall.PALO_ALTO_NETWORKS_CLOUD_NGFW =>
      val r = PALO_ALTO_NETWORKS_CLOUD_NGFW
      r
  }
  case object unknownToSdkVersion extends zio.aws.fms.model.ThirdPartyFirewall {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ThirdPartyFirewall =
      software.amazon.awssdk.services.fms.model.ThirdPartyFirewall.UNKNOWN_TO_SDK_VERSION
  }
  case object PALO_ALTO_NETWORKS_CLOUD_NGFW
      extends zio.aws.fms.model.ThirdPartyFirewall {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.ThirdPartyFirewall =
      software.amazon.awssdk.services.fms.model.ThirdPartyFirewall.PALO_ALTO_NETWORKS_CLOUD_NGFW
  }
}
