package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  TargetViolationReason,
  LengthBoundedString,
  ResourceId,
  ViolationTarget
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThirdPartyFirewallMissingFirewallViolation(
    violationTarget: Optional[ViolationTarget] = Optional.Absent,
    vpc: Optional[ResourceId] = Optional.Absent,
    availabilityZone: Optional[LengthBoundedString] = Optional.Absent,
    targetViolationReason: Optional[TargetViolationReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingFirewallViolation = {
    import ThirdPartyFirewallMissingFirewallViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingFirewallViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        vpc.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpc)
      .optionallyWith(
        availabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        targetViolationReason.map(value =>
          TargetViolationReason.unwrap(value): java.lang.String
        )
      )(_.targetViolationReason)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.ReadOnly =
    zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation
      .wrap(buildAwsValue())
}
object ThirdPartyFirewallMissingFirewallViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingFirewallViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation =
      zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation(
        violationTarget.map(value => value),
        vpc.map(value => value),
        availabilityZone.map(value => value),
        targetViolationReason.map(value => value)
      )
    def violationTarget: Optional[ViolationTarget]
    def vpc: Optional[ResourceId]
    def availabilityZone: Optional[LengthBoundedString]
    def targetViolationReason: Optional[TargetViolationReason]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getVpc: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTargetViolationReason: ZIO[Any, AwsError, TargetViolationReason] =
      AwsError.unwrapOptionField("targetViolationReason", targetViolationReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingFirewallViolation
  ) extends zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.ReadOnly {
    override val violationTarget: Optional[ViolationTarget] =
      zio.aws.core.internal
        .optionalFromNullable(impl.violationTarget())
        .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val vpc: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpc())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val availabilityZone: Optional[LengthBoundedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val targetViolationReason: Optional[TargetViolationReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetViolationReason())
        .map(value => zio.aws.fms.model.primitives.TargetViolationReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingFirewallViolation
  ): zio.aws.fms.model.ThirdPartyFirewallMissingFirewallViolation.ReadOnly =
    new Wrapper(impl)
}
