package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThirdPartyFirewallPolicy(
    firewallDeploymentModel: Optional[
      zio.aws.fms.model.FirewallDeploymentModel
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ThirdPartyFirewallPolicy = {
    import ThirdPartyFirewallPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ThirdPartyFirewallPolicy
      .builder()
      .optionallyWith(firewallDeploymentModel.map(value => value.unwrap))(
        _.firewallDeploymentModel
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ThirdPartyFirewallPolicy.ReadOnly =
    zio.aws.fms.model.ThirdPartyFirewallPolicy.wrap(buildAwsValue())
}
object ThirdPartyFirewallPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ThirdPartyFirewallPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ThirdPartyFirewallPolicy =
      zio.aws.fms.model
        .ThirdPartyFirewallPolicy(firewallDeploymentModel.map(value => value))
    def firewallDeploymentModel
        : Optional[zio.aws.fms.model.FirewallDeploymentModel]
    def getFirewallDeploymentModel
        : ZIO[Any, AwsError, zio.aws.fms.model.FirewallDeploymentModel] =
      AwsError.unwrapOptionField(
        "firewallDeploymentModel",
        firewallDeploymentModel
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ThirdPartyFirewallPolicy
  ) extends zio.aws.fms.model.ThirdPartyFirewallPolicy.ReadOnly {
    override val firewallDeploymentModel
        : Optional[zio.aws.fms.model.FirewallDeploymentModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallDeploymentModel())
        .map(value => zio.aws.fms.model.FirewallDeploymentModel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ThirdPartyFirewallPolicy
  ): zio.aws.fms.model.ThirdPartyFirewallPolicy.ReadOnly = new Wrapper(impl)
}
