package zio.aws.fms
import zio.aws.fms.model.GetProtocolsListResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.fms.{
  FmsAsyncClientBuilder,
  FmsAsyncClient
}
import software.amazon.awssdk.services.fms.model.{
  GetComplianceDetailRequest,
  GetViolationDetailsRequest,
  PolicySummary,
  GetProtocolsListResponse,
  GetViolationDetailsResponse,
  ListProtocolsListsResponse,
  PutNotificationChannelResponse,
  GetAdminAccountResponse,
  ListProtocolsListsRequest,
  PutNotificationChannelRequest,
  ListPoliciesRequest,
  PutProtocolsListResponse,
  DisassociateAdminAccountRequest,
  ListPoliciesResponse,
  PutAppsListRequest,
  AssociateAdminAccountRequest,
  ListComplianceStatusResponse,
  PutPolicyResponse,
  GetProtocolsListRequest,
  AppsListDataSummary,
  ListTagsForResourceRequest,
  GetNotificationChannelResponse,
  GetNotificationChannelRequest,
  ListComplianceStatusRequest,
  DisassociateAdminAccountResponse,
  GetProtectionStatusRequest,
  ListAppsListsResponse,
  GetAppsListRequest,
  PutProtocolsListRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetAdminAccountRequest,
  GetPolicyResponse,
  PolicyComplianceStatus,
  AssociateAdminAccountResponse,
  ListMemberAccountsResponse,
  DeleteProtocolsListResponse,
  DeletePolicyResponse,
  DeleteAppsListRequest,
  GetPolicyRequest,
  UntagResourceRequest,
  ListAppsListsRequest,
  GetAppsListResponse,
  ProtocolsListDataSummary,
  ListMemberAccountsRequest,
  TagResourceResponse,
  DeleteNotificationChannelRequest,
  DeletePolicyRequest,
  DeleteProtocolsListRequest,
  PutPolicyRequest,
  PutAppsListResponse,
  DeleteNotificationChannelResponse,
  TagResourceRequest,
  GetComplianceDetailResponse,
  GetProtectionStatusResponse,
  DeleteAppsListResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.fms.model.primitives.{ProtectionData, AWSAccountId}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Fms extends AspectSupport[Fms] {
  val api: FmsAsyncClient
  def listMemberAccounts(
      request: zio.aws.fms.model.ListMemberAccountsRequest
  ): ZStream[Any, AwsError, AWSAccountId]
  def listMemberAccountsPaginated(
      request: zio.aws.fms.model.ListMemberAccountsRequest
  ): IO[AwsError, zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly]
  def getNotificationChannel(
      request: zio.aws.fms.model.GetNotificationChannelRequest
  ): IO[AwsError, zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly]
  def getProtectionStatus(
      request: zio.aws.fms.model.GetProtectionStatusRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly,
    ProtectionData
  ]]
  def getProtectionStatusPaginated(
      request: zio.aws.fms.model.GetProtectionStatusRequest
  ): IO[AwsError, zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly]
  def deleteProtocolsList(
      request: zio.aws.fms.model.DeleteProtocolsListRequest
  ): IO[AwsError, Unit]
  def disassociateAdminAccount(
      request: zio.aws.fms.model.DisassociateAdminAccountRequest
  ): IO[AwsError, Unit]
  def getAdminAccount(
      request: zio.aws.fms.model.GetAdminAccountRequest
  ): IO[AwsError, zio.aws.fms.model.GetAdminAccountResponse.ReadOnly]
  def getProtocolsList(
      request: zio.aws.fms.model.GetProtocolsListRequest
  ): IO[AwsError, ReadOnly]
  def putPolicy(
      request: zio.aws.fms.model.PutPolicyRequest
  ): IO[AwsError, zio.aws.fms.model.PutPolicyResponse.ReadOnly]
  def putProtocolsList(
      request: zio.aws.fms.model.PutProtocolsListRequest
  ): IO[AwsError, zio.aws.fms.model.PutProtocolsListResponse.ReadOnly]
  def listPolicies(
      request: zio.aws.fms.model.ListPoliciesRequest
  ): ZStream[Any, AwsError, zio.aws.fms.model.PolicySummary.ReadOnly]
  def listPoliciesPaginated(
      request: zio.aws.fms.model.ListPoliciesRequest
  ): IO[AwsError, zio.aws.fms.model.ListPoliciesResponse.ReadOnly]
  def getViolationDetails(
      request: zio.aws.fms.model.GetViolationDetailsRequest
  ): IO[AwsError, zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.fms.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.fms.model.UntagResourceResponse.ReadOnly]
  def listComplianceStatus(
      request: zio.aws.fms.model.ListComplianceStatusRequest
  ): ZStream[Any, AwsError, zio.aws.fms.model.PolicyComplianceStatus.ReadOnly]
  def listComplianceStatusPaginated(
      request: zio.aws.fms.model.ListComplianceStatusRequest
  ): IO[AwsError, zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly]
  def deleteAppsList(
      request: zio.aws.fms.model.DeleteAppsListRequest
  ): IO[AwsError, Unit]
  def deleteNotificationChannel(
      request: zio.aws.fms.model.DeleteNotificationChannelRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(
      request: zio.aws.fms.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly]
  def getAppsList(
      request: zio.aws.fms.model.GetAppsListRequest
  ): IO[AwsError, zio.aws.fms.model.GetAppsListResponse.ReadOnly]
  def tagResource(
      request: zio.aws.fms.model.TagResourceRequest
  ): IO[AwsError, zio.aws.fms.model.TagResourceResponse.ReadOnly]
  def deletePolicy(
      request: zio.aws.fms.model.DeletePolicyRequest
  ): IO[AwsError, Unit]
  def getPolicy(
      request: zio.aws.fms.model.GetPolicyRequest
  ): IO[AwsError, zio.aws.fms.model.GetPolicyResponse.ReadOnly]
  def associateAdminAccount(
      request: zio.aws.fms.model.AssociateAdminAccountRequest
  ): IO[AwsError, Unit]
  def putAppsList(
      request: zio.aws.fms.model.PutAppsListRequest
  ): IO[AwsError, zio.aws.fms.model.PutAppsListResponse.ReadOnly]
  def listAppsLists(
      request: zio.aws.fms.model.ListAppsListsRequest
  ): ZStream[Any, AwsError, zio.aws.fms.model.AppsListDataSummary.ReadOnly]
  def listAppsListsPaginated(
      request: zio.aws.fms.model.ListAppsListsRequest
  ): IO[AwsError, zio.aws.fms.model.ListAppsListsResponse.ReadOnly]
  def putNotificationChannel(
      request: zio.aws.fms.model.PutNotificationChannelRequest
  ): IO[AwsError, Unit]
  def listProtocolsLists(
      request: zio.aws.fms.model.ListProtocolsListsRequest
  ): ZStream[Any, AwsError, zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly]
  def listProtocolsListsPaginated(
      request: zio.aws.fms.model.ListProtocolsListsRequest
  ): IO[AwsError, zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly]
  def getComplianceDetail(
      request: zio.aws.fms.model.GetComplianceDetailRequest
  ): IO[AwsError, zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly]
}
object Fms {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Fms] = customized(identity)
  def customized(
      customization: FmsAsyncClientBuilder => FmsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Fms] = managed(
    customization
  ).toLayer
  def managed(
      customization: FmsAsyncClientBuilder => FmsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Fms] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = FmsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[FmsAsyncClient, FmsAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[FmsAsyncClient, FmsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new FmsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class FmsImpl[R](
      override val api: FmsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Fms
      with AwsServiceBase[R] {
    override val serviceName: String = "Fms"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FmsImpl[R1] = new FmsImpl(api, newAspect, r)
    def listMemberAccounts(
        request: zio.aws.fms.model.ListMemberAccountsRequest
    ): ZStream[Any, AwsError, AWSAccountId] = asyncSimplePaginatedRequest[
      ListMemberAccountsRequest,
      ListMemberAccountsResponse,
      java.lang.String
    ](
      "listMemberAccounts",
      api.listMemberAccounts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.memberAccounts().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.fms.model.primitives.AWSAccountId(item))
      .provideEnvironment(r)
    def listMemberAccountsPaginated(
        request: zio.aws.fms.model.ListMemberAccountsRequest
    ): IO[AwsError, zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly] =
      asyncRequestResponse[
        ListMemberAccountsRequest,
        ListMemberAccountsResponse
      ]("listMemberAccounts", api.listMemberAccounts)(request.buildAwsValue())
        .map(zio.aws.fms.model.ListMemberAccountsResponse.wrap)
        .provideEnvironment(r)
    def getNotificationChannel(
        request: zio.aws.fms.model.GetNotificationChannelRequest
    ): IO[AwsError, zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly] =
      asyncRequestResponse[
        GetNotificationChannelRequest,
        GetNotificationChannelResponse
      ]("getNotificationChannel", api.getNotificationChannel)(
        request.buildAwsValue()
      ).map(zio.aws.fms.model.GetNotificationChannelResponse.wrap)
        .provideEnvironment(r)
    def getProtectionStatus(
        request: zio.aws.fms.model.GetProtectionStatusRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly,
      ProtectionData
    ]] = asyncPaginatedRequest[
      GetProtectionStatusRequest,
      GetProtectionStatusResponse,
      java.lang.String
    ](
      "getProtectionStatus",
      api.getProtectionStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk(r.data())
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.fms.model.GetProtectionStatusResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.fms.model.primitives.ProtectionData(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getProtectionStatusPaginated(
        request: zio.aws.fms.model.GetProtectionStatusRequest
    ): IO[AwsError, zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly] =
      asyncRequestResponse[
        GetProtectionStatusRequest,
        GetProtectionStatusResponse
      ]("getProtectionStatus", api.getProtectionStatus)(request.buildAwsValue())
        .map(zio.aws.fms.model.GetProtectionStatusResponse.wrap)
        .provideEnvironment(r)
    def deleteProtocolsList(
        request: zio.aws.fms.model.DeleteProtocolsListRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteProtocolsListRequest,
      DeleteProtocolsListResponse
    ]("deleteProtocolsList", api.deleteProtocolsList)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disassociateAdminAccount(
        request: zio.aws.fms.model.DisassociateAdminAccountRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateAdminAccountRequest,
      DisassociateAdminAccountResponse
    ]("disassociateAdminAccount", api.disassociateAdminAccount)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getAdminAccount(
        request: zio.aws.fms.model.GetAdminAccountRequest
    ): IO[AwsError, zio.aws.fms.model.GetAdminAccountResponse.ReadOnly] =
      asyncRequestResponse[GetAdminAccountRequest, GetAdminAccountResponse](
        "getAdminAccount",
        api.getAdminAccount
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.GetAdminAccountResponse.wrap)
        .provideEnvironment(r)
    def getProtocolsList(
        request: zio.aws.fms.model.GetProtocolsListRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetProtocolsListRequest, GetProtocolsListResponse](
        "getProtocolsList",
        api.getProtocolsList
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.GetProtocolsListResponse.wrap)
        .provideEnvironment(r)
    def putPolicy(
        request: zio.aws.fms.model.PutPolicyRequest
    ): IO[AwsError, zio.aws.fms.model.PutPolicyResponse.ReadOnly] =
      asyncRequestResponse[PutPolicyRequest, PutPolicyResponse](
        "putPolicy",
        api.putPolicy
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.PutPolicyResponse.wrap)
        .provideEnvironment(r)
    def putProtocolsList(
        request: zio.aws.fms.model.PutProtocolsListRequest
    ): IO[AwsError, zio.aws.fms.model.PutProtocolsListResponse.ReadOnly] =
      asyncRequestResponse[PutProtocolsListRequest, PutProtocolsListResponse](
        "putProtocolsList",
        api.putProtocolsList
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.PutProtocolsListResponse.wrap)
        .provideEnvironment(r)
    def listPolicies(
        request: zio.aws.fms.model.ListPoliciesRequest
    ): ZStream[Any, AwsError, zio.aws.fms.model.PolicySummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListPoliciesRequest,
        ListPoliciesResponse,
        PolicySummary
      ](
        "listPolicies",
        api.listPolicies,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.policyList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fms.model.PolicySummary.wrap(item))
        .provideEnvironment(r)
    def listPoliciesPaginated(
        request: zio.aws.fms.model.ListPoliciesRequest
    ): IO[AwsError, zio.aws.fms.model.ListPoliciesResponse.ReadOnly] =
      asyncRequestResponse[ListPoliciesRequest, ListPoliciesResponse](
        "listPolicies",
        api.listPolicies
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.ListPoliciesResponse.wrap)
        .provideEnvironment(r)
    def getViolationDetails(
        request: zio.aws.fms.model.GetViolationDetailsRequest
    ): IO[AwsError, zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly] =
      asyncRequestResponse[
        GetViolationDetailsRequest,
        GetViolationDetailsResponse
      ]("getViolationDetails", api.getViolationDetails)(request.buildAwsValue())
        .map(zio.aws.fms.model.GetViolationDetailsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.fms.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.fms.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listComplianceStatus(
        request: zio.aws.fms.model.ListComplianceStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.fms.model.PolicyComplianceStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListComplianceStatusRequest,
      ListComplianceStatusResponse,
      PolicyComplianceStatus
    ](
      "listComplianceStatus",
      api.listComplianceStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.policyComplianceStatusList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.fms.model.PolicyComplianceStatus.wrap(item))
      .provideEnvironment(r)
    def listComplianceStatusPaginated(
        request: zio.aws.fms.model.ListComplianceStatusRequest
    ): IO[AwsError, zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly] =
      asyncRequestResponse[
        ListComplianceStatusRequest,
        ListComplianceStatusResponse
      ]("listComplianceStatus", api.listComplianceStatus)(
        request.buildAwsValue()
      ).map(zio.aws.fms.model.ListComplianceStatusResponse.wrap)
        .provideEnvironment(r)
    def deleteAppsList(
        request: zio.aws.fms.model.DeleteAppsListRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAppsListRequest, DeleteAppsListResponse](
        "deleteAppsList",
        api.deleteAppsList
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteNotificationChannel(
        request: zio.aws.fms.model.DeleteNotificationChannelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteNotificationChannelRequest,
      DeleteNotificationChannelResponse
    ]("deleteNotificationChannel", api.deleteNotificationChannel)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.fms.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.fms.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getAppsList(
        request: zio.aws.fms.model.GetAppsListRequest
    ): IO[AwsError, zio.aws.fms.model.GetAppsListResponse.ReadOnly] =
      asyncRequestResponse[GetAppsListRequest, GetAppsListResponse](
        "getAppsList",
        api.getAppsList
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.GetAppsListResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.fms.model.TagResourceRequest
    ): IO[AwsError, zio.aws.fms.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deletePolicy(
        request: zio.aws.fms.model.DeletePolicyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeletePolicyRequest, DeletePolicyResponse](
        "deletePolicy",
        api.deletePolicy
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getPolicy(
        request: zio.aws.fms.model.GetPolicyRequest
    ): IO[AwsError, zio.aws.fms.model.GetPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetPolicyRequest, GetPolicyResponse](
        "getPolicy",
        api.getPolicy
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.GetPolicyResponse.wrap)
        .provideEnvironment(r)
    def associateAdminAccount(
        request: zio.aws.fms.model.AssociateAdminAccountRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AssociateAdminAccountRequest,
      AssociateAdminAccountResponse
    ]("associateAdminAccount", api.associateAdminAccount)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putAppsList(
        request: zio.aws.fms.model.PutAppsListRequest
    ): IO[AwsError, zio.aws.fms.model.PutAppsListResponse.ReadOnly] =
      asyncRequestResponse[PutAppsListRequest, PutAppsListResponse](
        "putAppsList",
        api.putAppsList
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.PutAppsListResponse.wrap)
        .provideEnvironment(r)
    def listAppsLists(
        request: zio.aws.fms.model.ListAppsListsRequest
    ): ZStream[Any, AwsError, zio.aws.fms.model.AppsListDataSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAppsListsRequest,
        ListAppsListsResponse,
        AppsListDataSummary
      ](
        "listAppsLists",
        api.listAppsLists,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.appsLists().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.fms.model.AppsListDataSummary.wrap(item))
        .provideEnvironment(r)
    def listAppsListsPaginated(
        request: zio.aws.fms.model.ListAppsListsRequest
    ): IO[AwsError, zio.aws.fms.model.ListAppsListsResponse.ReadOnly] =
      asyncRequestResponse[ListAppsListsRequest, ListAppsListsResponse](
        "listAppsLists",
        api.listAppsLists
      )(request.buildAwsValue())
        .map(zio.aws.fms.model.ListAppsListsResponse.wrap)
        .provideEnvironment(r)
    def putNotificationChannel(
        request: zio.aws.fms.model.PutNotificationChannelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutNotificationChannelRequest,
      PutNotificationChannelResponse
    ]("putNotificationChannel", api.putNotificationChannel)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listProtocolsLists(
        request: zio.aws.fms.model.ListProtocolsListsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListProtocolsListsRequest,
      ListProtocolsListsResponse,
      ProtocolsListDataSummary
    ](
      "listProtocolsLists",
      api.listProtocolsLists,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.protocolsLists().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.fms.model.ProtocolsListDataSummary.wrap(item))
      .provideEnvironment(r)
    def listProtocolsListsPaginated(
        request: zio.aws.fms.model.ListProtocolsListsRequest
    ): IO[AwsError, zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly] =
      asyncRequestResponse[
        ListProtocolsListsRequest,
        ListProtocolsListsResponse
      ]("listProtocolsLists", api.listProtocolsLists)(request.buildAwsValue())
        .map(zio.aws.fms.model.ListProtocolsListsResponse.wrap)
        .provideEnvironment(r)
    def getComplianceDetail(
        request: zio.aws.fms.model.GetComplianceDetailRequest
    ): IO[AwsError, zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly] =
      asyncRequestResponse[
        GetComplianceDetailRequest,
        GetComplianceDetailResponse
      ]("getComplianceDetail", api.getComplianceDetail)(request.buildAwsValue())
        .map(zio.aws.fms.model.GetComplianceDetailResponse.wrap)
        .provideEnvironment(r)
  }
  def listMemberAccounts(
      request: zio.aws.fms.model.ListMemberAccountsRequest
  ): ZStream[zio.aws.fms.Fms, AwsError, AWSAccountId] =
    ZStream.serviceWithStream(_.listMemberAccounts(request))
  def listMemberAccountsPaginated(
      request: zio.aws.fms.model.ListMemberAccountsRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ListMemberAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMemberAccountsPaginated(request))
  def getNotificationChannel(
      request: zio.aws.fms.model.GetNotificationChannelRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetNotificationChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNotificationChannel(request))
  def getProtectionStatus(
      request: zio.aws.fms.model.GetProtectionStatusRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, StreamingOutputResult[
    Any,
    zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly,
    ProtectionData
  ]] = ZIO.serviceWithZIO(_.getProtectionStatus(request))
  def getProtectionStatusPaginated(
      request: zio.aws.fms.model.GetProtectionStatusRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProtectionStatusPaginated(request))
  def deleteProtocolsList(
      request: zio.aws.fms.model.DeleteProtocolsListRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteProtocolsList(request))
  def disassociateAdminAccount(
      request: zio.aws.fms.model.DisassociateAdminAccountRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateAdminAccount(request))
  def getAdminAccount(request: zio.aws.fms.model.GetAdminAccountRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdminAccount(request))
  def getProtocolsList(
      request: zio.aws.fms.model.GetProtocolsListRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getProtocolsList(request))
  def putPolicy(request: zio.aws.fms.model.PutPolicyRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.PutPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putPolicy(request))
  def putProtocolsList(request: zio.aws.fms.model.PutProtocolsListRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.PutProtocolsListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putProtocolsList(request))
  def listPolicies(request: zio.aws.fms.model.ListPoliciesRequest): ZStream[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.PolicySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPolicies(request))
  def listPoliciesPaginated(
      request: zio.aws.fms.model.ListPoliciesRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ListPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPoliciesPaginated(request))
  def getViolationDetails(
      request: zio.aws.fms.model.GetViolationDetailsRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetViolationDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getViolationDetails(request))
  def untagResource(request: zio.aws.fms.model.UntagResourceRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listComplianceStatus(
      request: zio.aws.fms.model.ListComplianceStatusRequest
  ): ZStream[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.PolicyComplianceStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.listComplianceStatus(request))
  def listComplianceStatusPaginated(
      request: zio.aws.fms.model.ListComplianceStatusRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComplianceStatusPaginated(request))
  def deleteAppsList(
      request: zio.aws.fms.model.DeleteAppsListRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAppsList(request))
  def deleteNotificationChannel(
      request: zio.aws.fms.model.DeleteNotificationChannelRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNotificationChannel(request))
  def listTagsForResource(
      request: zio.aws.fms.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getAppsList(request: zio.aws.fms.model.GetAppsListRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetAppsListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppsList(request))
  def tagResource(request: zio.aws.fms.model.TagResourceRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deletePolicy(
      request: zio.aws.fms.model.DeletePolicyRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePolicy(request))
  def getPolicy(request: zio.aws.fms.model.GetPolicyRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPolicy(request))
  def associateAdminAccount(
      request: zio.aws.fms.model.AssociateAdminAccountRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateAdminAccount(request))
  def putAppsList(request: zio.aws.fms.model.PutAppsListRequest): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.PutAppsListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAppsList(request))
  def listAppsLists(request: zio.aws.fms.model.ListAppsListsRequest): ZStream[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.AppsListDataSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAppsLists(request))
  def listAppsListsPaginated(
      request: zio.aws.fms.model.ListAppsListsRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ListAppsListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppsListsPaginated(request))
  def putNotificationChannel(
      request: zio.aws.fms.model.PutNotificationChannelRequest
  ): ZIO[zio.aws.fms.Fms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putNotificationChannel(request))
  def listProtocolsLists(
      request: zio.aws.fms.model.ListProtocolsListsRequest
  ): ZStream[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProtocolsLists(request))
  def listProtocolsListsPaginated(
      request: zio.aws.fms.model.ListProtocolsListsRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProtocolsListsPaginated(request))
  def getComplianceDetail(
      request: zio.aws.fms.model.GetComplianceDetailRequest
  ): ZIO[
    zio.aws.fms.Fms,
    AwsError,
    zio.aws.fms.model.GetComplianceDetailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComplianceDetail(request))
}
