package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait AccountRoleStatus {
  def unwrap: software.amazon.awssdk.services.fms.model.AccountRoleStatus
}
object AccountRoleStatus {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.AccountRoleStatus
  ): zio.aws.fms.model.AccountRoleStatus = value match {
    case software.amazon.awssdk.services.fms.model.AccountRoleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.AccountRoleStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.fms.model.AccountRoleStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fms.model.AccountRoleStatus.PENDING_DELETION =>
      val r = PENDING_DELETION
      r
    case software.amazon.awssdk.services.fms.model.AccountRoleStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fms.model.AccountRoleStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.fms.model.AccountRoleStatus {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.AccountRoleStatus =
      software.amazon.awssdk.services.fms.model.AccountRoleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY extends zio.aws.fms.model.AccountRoleStatus {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.AccountRoleStatus =
      software.amazon.awssdk.services.fms.model.AccountRoleStatus.READY
  }
  case object CREATING extends zio.aws.fms.model.AccountRoleStatus {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.AccountRoleStatus =
      software.amazon.awssdk.services.fms.model.AccountRoleStatus.CREATING
  }
  case object PENDING_DELETION extends zio.aws.fms.model.AccountRoleStatus {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.AccountRoleStatus =
      software.amazon.awssdk.services.fms.model.AccountRoleStatus.PENDING_DELETION
  }
  case object DELETING extends zio.aws.fms.model.AccountRoleStatus {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.AccountRoleStatus =
      software.amazon.awssdk.services.fms.model.AccountRoleStatus.DELETING
  }
  case object DELETED extends zio.aws.fms.model.AccountRoleStatus {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.AccountRoleStatus =
      software.amazon.awssdk.services.fms.model.AccountRoleStatus.DELETED
  }
}
