package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ListId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteProtocolsListRequest(listId: ListId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DeleteProtocolsListRequest = {
    import DeleteProtocolsListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DeleteProtocolsListRequest
      .builder()
      .listId(ListId.unwrap(listId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.DeleteProtocolsListRequest.ReadOnly =
    zio.aws.fms.model.DeleteProtocolsListRequest.wrap(buildAwsValue())
}
object DeleteProtocolsListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DeleteProtocolsListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DeleteProtocolsListRequest =
      zio.aws.fms.model.DeleteProtocolsListRequest(listId)
    def listId: ListId
    def getListId: ZIO[Any, Nothing, ListId] = ZIO.succeed(listId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DeleteProtocolsListRequest
  ) extends zio.aws.fms.model.DeleteProtocolsListRequest.ReadOnly {
    override val listId: ListId =
      zio.aws.fms.model.primitives.ListId(impl.listId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DeleteProtocolsListRequest
  ): zio.aws.fms.model.DeleteProtocolsListRequest.ReadOnly = new Wrapper(impl)
}
