package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId, CIDR}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExpectedRoute(
    ipV4Cidr: Option[CIDR] = None,
    prefixListId: Option[CIDR] = None,
    ipV6Cidr: Option[CIDR] = None,
    contributingSubnets: Option[Iterable[ResourceId]] = None,
    allowedTargets: Option[Iterable[LengthBoundedString]] = None,
    routeTableId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ExpectedRoute = {
    import ExpectedRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ExpectedRoute
      .builder()
      .optionallyWith(
        ipV4Cidr.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.ipV4Cidr)
      .optionallyWith(
        prefixListId.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.prefixListId)
      .optionallyWith(
        ipV6Cidr.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.ipV6Cidr)
      .optionallyWith(
        contributingSubnets.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.contributingSubnets)
      .optionallyWith(
        allowedTargets.map(value =>
          value.map { item =>
            LengthBoundedString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedTargets)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ExpectedRoute.ReadOnly =
    zio.aws.fms.model.ExpectedRoute.wrap(buildAwsValue())
}
object ExpectedRoute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.ExpectedRoute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ExpectedRoute =
      zio.aws.fms.model.ExpectedRoute(
        ipV4Cidr.map(value => value),
        prefixListId.map(value => value),
        ipV6Cidr.map(value => value),
        contributingSubnets.map(value => value),
        allowedTargets.map(value => value),
        routeTableId.map(value => value)
      )
    def ipV4Cidr: Option[CIDR]
    def prefixListId: Option[CIDR]
    def ipV6Cidr: Option[CIDR]
    def contributingSubnets: Option[List[ResourceId]]
    def allowedTargets: Option[List[LengthBoundedString]]
    def routeTableId: Option[ResourceId]
    def getIpV4Cidr: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("ipV4Cidr", ipV4Cidr)
    def getPrefixListId: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getIpV6Cidr: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("ipV6Cidr", ipV6Cidr)
    def getContributingSubnets: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("contributingSubnets", contributingSubnets)
    def getAllowedTargets: ZIO[Any, AwsError, List[LengthBoundedString]] =
      AwsError.unwrapOptionField("allowedTargets", allowedTargets)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ExpectedRoute
  ) extends zio.aws.fms.model.ExpectedRoute.ReadOnly {
    override val ipV4Cidr: Option[CIDR] = scala
      .Option(impl.ipV4Cidr())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val prefixListId: Option[CIDR] = scala
      .Option(impl.prefixListId())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val ipV6Cidr: Option[CIDR] = scala
      .Option(impl.ipV6Cidr())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val contributingSubnets: Option[List[ResourceId]] = scala
      .Option(impl.contributingSubnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.ResourceId(item)
        }.toList
      )
    override val allowedTargets: Option[List[LengthBoundedString]] = scala
      .Option(impl.allowedTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.LengthBoundedString(item)
        }.toList
      )
    override val routeTableId: Option[ResourceId] = scala
      .Option(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ExpectedRoute
  ): zio.aws.fms.model.ExpectedRoute.ReadOnly = new Wrapper(impl)
}
