package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  PaginationToken,
  ProtectionData,
  AWSAccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetProtectionStatusResponse(
    adminAccountId: Option[AWSAccountId] = None,
    serviceType: Option[zio.aws.fms.model.SecurityServiceType] = None,
    data: Option[ProtectionData] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse = {
    import GetProtectionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
      .builder()
      .optionallyWith(
        adminAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.adminAccountId)
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .optionallyWith(
        data.map(value => ProtectionData.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly =
    zio.aws.fms.model.GetProtectionStatusResponse.wrap(buildAwsValue())
}
object GetProtectionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtectionStatusResponse =
      zio.aws.fms.model.GetProtectionStatusResponse(
        adminAccountId.map(value => value),
        serviceType.map(value => value),
        data.map(value => value),
        nextToken.map(value => value)
      )
    def adminAccountId: Option[AWSAccountId]
    def serviceType: Option[zio.aws.fms.model.SecurityServiceType]
    def data: Option[ProtectionData]
    def nextToken: Option[PaginationToken]
    def getAdminAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("adminAccountId", adminAccountId)
    def getServiceType
        : ZIO[Any, AwsError, zio.aws.fms.model.SecurityServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getData: ZIO[Any, AwsError, ProtectionData] =
      AwsError.unwrapOptionField("data", data)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
  ) extends zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly {
    override val adminAccountId: Option[AWSAccountId] = scala
      .Option(impl.adminAccountId())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val serviceType: Option[zio.aws.fms.model.SecurityServiceType] =
      scala
        .Option(impl.serviceType())
        .map(value => zio.aws.fms.model.SecurityServiceType.wrap(value))
    override val data: Option[ProtectionData] = scala
      .Option(impl.data())
      .map(value => zio.aws.fms.model.primitives.ProtectionData(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse
  ): zio.aws.fms.model.GetProtectionStatusResponse.ReadOnly = new Wrapper(impl)
}
