package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPoliciesResponse(
    policyList: Option[Iterable[zio.aws.fms.model.PolicySummary]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListPoliciesResponse = {
    import ListPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListPoliciesResponse
      .builder()
      .optionallyWith(
        policyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListPoliciesResponse.ReadOnly =
    zio.aws.fms.model.ListPoliciesResponse.wrap(buildAwsValue())
}
object ListPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListPoliciesResponse =
      zio.aws.fms.model.ListPoliciesResponse(
        policyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def policyList: Option[List[zio.aws.fms.model.PolicySummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getPolicyList
        : ZIO[Any, AwsError, List[zio.aws.fms.model.PolicySummary.ReadOnly]] =
      AwsError.unwrapOptionField("policyList", policyList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesResponse
  ) extends zio.aws.fms.model.ListPoliciesResponse.ReadOnly {
    override val policyList
        : Option[List[zio.aws.fms.model.PolicySummary.ReadOnly]] = scala
      .Option(impl.policyList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.PolicySummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesResponse
  ): zio.aws.fms.model.ListPoliciesResponse.ReadOnly = new Wrapper(impl)
}
