package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.fms.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListTagsForResourceRequest =
      zio.aws.fms.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest
  ) extends zio.aws.fms.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.fms.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest
  ): zio.aws.fms.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
