package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tagList: Option[Iterable[zio.aws.fms.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.fms.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListTagsForResourceResponse =
      zio.aws.fms.model.ListTagsForResourceResponse(
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagList: Option[List[zio.aws.fms.model.Tag.ReadOnly]]
    def getTagList: ZIO[Any, AwsError, List[zio.aws.fms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse
  ) extends zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly {
    override val tagList: Option[List[zio.aws.fms.model.Tag.ReadOnly]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse
  ): zio.aws.fms.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(impl)
}
