package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyComplianceStatusType {
  def unwrap
      : software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType
}
object PolicyComplianceStatusType {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType
  ): zio.aws.fms.model.PolicyComplianceStatusType = value match {
    case software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType.COMPLIANT =>
      val r = COMPLIANT
      r
    case software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType.NON_COMPLIANT =>
      val r = NON_COMPLIANT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fms.model.PolicyComplianceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType =
      software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANT extends zio.aws.fms.model.PolicyComplianceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType =
      software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType.COMPLIANT
  }
  case object NON_COMPLIANT
      extends zio.aws.fms.model.PolicyComplianceStatusType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType =
      software.amazon.awssdk.services.fms.model.PolicyComplianceStatusType.NON_COMPLIANT
  }
}
