package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PossibleRemediationActions(
    description: Option[LengthBoundedString] = None,
    actions: Option[Iterable[zio.aws.fms.model.PossibleRemediationAction]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PossibleRemediationActions = {
    import PossibleRemediationActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PossibleRemediationActions
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PossibleRemediationActions.ReadOnly =
    zio.aws.fms.model.PossibleRemediationActions.wrap(buildAwsValue())
}
object PossibleRemediationActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PossibleRemediationActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PossibleRemediationActions =
      zio.aws.fms.model.PossibleRemediationActions(
        description.map(value => value),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[LengthBoundedString]
    def actions
        : Option[List[zio.aws.fms.model.PossibleRemediationAction.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.fms.model.PossibleRemediationAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PossibleRemediationActions
  ) extends zio.aws.fms.model.PossibleRemediationActions.ReadOnly {
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val actions
        : Option[List[zio.aws.fms.model.PossibleRemediationAction.ReadOnly]] =
      scala
        .Option(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.PossibleRemediationAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PossibleRemediationActions
  ): zio.aws.fms.model.PossibleRemediationActions.ReadOnly = new Wrapper(impl)
}
