package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  Protocol,
  PreviousListVersion,
  UpdateToken,
  TimeStamp,
  ListId,
  ResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ProtocolsListData(
    listId: Option[ListId] = None,
    listName: ResourceName,
    listUpdateToken: Option[UpdateToken] = None,
    createTime: Option[TimeStamp] = None,
    lastUpdateTime: Option[TimeStamp] = None,
    protocolsList: Iterable[Protocol],
    previousProtocolsList: Option[
      Map[PreviousListVersion, Iterable[Protocol]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ProtocolsListData = {
    import ProtocolsListData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ProtocolsListData
      .builder()
      .optionallyWith(
        listId.map(value => ListId.unwrap(value): java.lang.String)
      )(_.listId)
      .listName(ResourceName.unwrap(listName): java.lang.String)
      .optionallyWith(
        listUpdateToken.map(value =>
          UpdateToken.unwrap(value): java.lang.String
        )
      )(_.listUpdateToken)
      .optionallyWith(
        createTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        lastUpdateTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .protocolsList(protocolsList.map { item =>
        Protocol.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        previousProtocolsList.map(value =>
          value
            .map({ case (key, value) =>
              (PreviousListVersion.unwrap(key): java.lang.String) -> value.map {
                item =>
                  Protocol.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.previousProtocolsList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ProtocolsListData.ReadOnly =
    zio.aws.fms.model.ProtocolsListData.wrap(buildAwsValue())
}
object ProtocolsListData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ProtocolsListData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ProtocolsListData =
      zio.aws.fms.model.ProtocolsListData(
        listId.map(value => value),
        listName,
        listUpdateToken.map(value => value),
        createTime.map(value => value),
        lastUpdateTime.map(value => value),
        protocolsList,
        previousProtocolsList.map(value => value)
      )
    def listId: Option[ListId]
    def listName: ResourceName
    def listUpdateToken: Option[UpdateToken]
    def createTime: Option[TimeStamp]
    def lastUpdateTime: Option[TimeStamp]
    def protocolsList: List[Protocol]
    def previousProtocolsList: Option[Map[PreviousListVersion, List[Protocol]]]
    def getListId: ZIO[Any, AwsError, ListId] =
      AwsError.unwrapOptionField("listId", listId)
    def getListName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(listName)
    def getListUpdateToken: ZIO[Any, AwsError, UpdateToken] =
      AwsError.unwrapOptionField("listUpdateToken", listUpdateToken)
    def getCreateTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastUpdateTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getProtocolsList: ZIO[Any, Nothing, List[Protocol]] =
      ZIO.succeed(protocolsList)
    def getPreviousProtocolsList
        : ZIO[Any, AwsError, Map[PreviousListVersion, List[Protocol]]] =
      AwsError.unwrapOptionField("previousProtocolsList", previousProtocolsList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ProtocolsListData
  ) extends zio.aws.fms.model.ProtocolsListData.ReadOnly {
    override val listId: Option[ListId] = scala
      .Option(impl.listId())
      .map(value => zio.aws.fms.model.primitives.ListId(value))
    override val listName: ResourceName =
      zio.aws.fms.model.primitives.ResourceName(impl.listName())
    override val listUpdateToken: Option[UpdateToken] = scala
      .Option(impl.listUpdateToken())
      .map(value => zio.aws.fms.model.primitives.UpdateToken(value))
    override val createTime: Option[TimeStamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val lastUpdateTime: Option[TimeStamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val protocolsList: List[Protocol] = impl
      .protocolsList()
      .asScala
      .map { item =>
        zio.aws.fms.model.primitives.Protocol(item)
      }
      .toList
    override val previousProtocolsList
        : Option[Map[PreviousListVersion, List[Protocol]]] = scala
      .Option(impl.previousProtocolsList())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.fms.model.primitives
              .PreviousListVersion(key) -> value.asScala.map { item =>
              zio.aws.fms.model.primitives.Protocol(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ProtocolsListData
  ): zio.aws.fms.model.ProtocolsListData.ReadOnly = new Wrapper(impl)
}
