package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutProtocolsListRequest(
    protocolsList: zio.aws.fms.model.ProtocolsListData,
    tagList: Option[Iterable[zio.aws.fms.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PutProtocolsListRequest = {
    import PutProtocolsListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PutProtocolsListRequest
      .builder()
      .protocolsList(protocolsList.buildAwsValue())
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PutProtocolsListRequest.ReadOnly =
    zio.aws.fms.model.PutProtocolsListRequest.wrap(buildAwsValue())
}
object PutProtocolsListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PutProtocolsListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PutProtocolsListRequest =
      zio.aws.fms.model.PutProtocolsListRequest(
        protocolsList.asEditable,
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def protocolsList: zio.aws.fms.model.ProtocolsListData.ReadOnly
    def tagList: Option[List[zio.aws.fms.model.Tag.ReadOnly]]
    def getProtocolsList
        : ZIO[Any, Nothing, zio.aws.fms.model.ProtocolsListData.ReadOnly] =
      ZIO.succeed(protocolsList)
    def getTagList: ZIO[Any, AwsError, List[zio.aws.fms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PutProtocolsListRequest
  ) extends zio.aws.fms.model.PutProtocolsListRequest.ReadOnly {
    override val protocolsList: zio.aws.fms.model.ProtocolsListData.ReadOnly =
      zio.aws.fms.model.ProtocolsListData.wrap(impl.protocolsList())
    override val tagList: Option[List[zio.aws.fms.model.Tag.ReadOnly]] = scala
      .Option(impl.tagList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PutProtocolsListRequest
  ): zio.aws.fms.model.PutProtocolsListRequest.ReadOnly = new Wrapper(impl)
}
