package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RemediationAction(
    description: Option[LengthBoundedString] = None,
    ec2CreateRouteAction: Option[zio.aws.fms.model.EC2CreateRouteAction] = None,
    ec2ReplaceRouteAction: Option[zio.aws.fms.model.EC2ReplaceRouteAction] =
      None,
    ec2DeleteRouteAction: Option[zio.aws.fms.model.EC2DeleteRouteAction] = None,
    ec2CopyRouteTableAction: Option[zio.aws.fms.model.EC2CopyRouteTableAction] =
      None,
    ec2ReplaceRouteTableAssociationAction: Option[
      zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction
    ] = None,
    ec2AssociateRouteTableAction: Option[
      zio.aws.fms.model.EC2AssociateRouteTableAction
    ] = None,
    ec2CreateRouteTableAction: Option[
      zio.aws.fms.model.EC2CreateRouteTableAction
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.RemediationAction = {
    import RemediationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.RemediationAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(ec2CreateRouteAction.map(value => value.buildAwsValue()))(
        _.ec2CreateRouteAction
      )
      .optionallyWith(
        ec2ReplaceRouteAction.map(value => value.buildAwsValue())
      )(_.ec2ReplaceRouteAction)
      .optionallyWith(ec2DeleteRouteAction.map(value => value.buildAwsValue()))(
        _.ec2DeleteRouteAction
      )
      .optionallyWith(
        ec2CopyRouteTableAction.map(value => value.buildAwsValue())
      )(_.ec2CopyRouteTableAction)
      .optionallyWith(
        ec2ReplaceRouteTableAssociationAction.map(value =>
          value.buildAwsValue()
        )
      )(_.ec2ReplaceRouteTableAssociationAction)
      .optionallyWith(
        ec2AssociateRouteTableAction.map(value => value.buildAwsValue())
      )(_.ec2AssociateRouteTableAction)
      .optionallyWith(
        ec2CreateRouteTableAction.map(value => value.buildAwsValue())
      )(_.ec2CreateRouteTableAction)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.RemediationAction.ReadOnly =
    zio.aws.fms.model.RemediationAction.wrap(buildAwsValue())
}
object RemediationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.RemediationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.RemediationAction =
      zio.aws.fms.model.RemediationAction(
        description.map(value => value),
        ec2CreateRouteAction.map(value => value.asEditable),
        ec2ReplaceRouteAction.map(value => value.asEditable),
        ec2DeleteRouteAction.map(value => value.asEditable),
        ec2CopyRouteTableAction.map(value => value.asEditable),
        ec2ReplaceRouteTableAssociationAction.map(value => value.asEditable),
        ec2AssociateRouteTableAction.map(value => value.asEditable),
        ec2CreateRouteTableAction.map(value => value.asEditable)
      )
    def description: Option[LengthBoundedString]
    def ec2CreateRouteAction
        : Option[zio.aws.fms.model.EC2CreateRouteAction.ReadOnly]
    def ec2ReplaceRouteAction
        : Option[zio.aws.fms.model.EC2ReplaceRouteAction.ReadOnly]
    def ec2DeleteRouteAction
        : Option[zio.aws.fms.model.EC2DeleteRouteAction.ReadOnly]
    def ec2CopyRouteTableAction
        : Option[zio.aws.fms.model.EC2CopyRouteTableAction.ReadOnly]
    def ec2ReplaceRouteTableAssociationAction: Option[
      zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.ReadOnly
    ]
    def ec2AssociateRouteTableAction
        : Option[zio.aws.fms.model.EC2AssociateRouteTableAction.ReadOnly]
    def ec2CreateRouteTableAction
        : Option[zio.aws.fms.model.EC2CreateRouteTableAction.ReadOnly]
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getEc2CreateRouteAction
        : ZIO[Any, AwsError, zio.aws.fms.model.EC2CreateRouteAction.ReadOnly] =
      AwsError.unwrapOptionField("ec2CreateRouteAction", ec2CreateRouteAction)
    def getEc2ReplaceRouteAction
        : ZIO[Any, AwsError, zio.aws.fms.model.EC2ReplaceRouteAction.ReadOnly] =
      AwsError.unwrapOptionField("ec2ReplaceRouteAction", ec2ReplaceRouteAction)
    def getEc2DeleteRouteAction
        : ZIO[Any, AwsError, zio.aws.fms.model.EC2DeleteRouteAction.ReadOnly] =
      AwsError.unwrapOptionField("ec2DeleteRouteAction", ec2DeleteRouteAction)
    def getEc2CopyRouteTableAction: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.EC2CopyRouteTableAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2CopyRouteTableAction",
      ec2CopyRouteTableAction
    )
    def getEc2ReplaceRouteTableAssociationAction: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2ReplaceRouteTableAssociationAction",
      ec2ReplaceRouteTableAssociationAction
    )
    def getEc2AssociateRouteTableAction: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.EC2AssociateRouteTableAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2AssociateRouteTableAction",
      ec2AssociateRouteTableAction
    )
    def getEc2CreateRouteTableAction: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.EC2CreateRouteTableAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ec2CreateRouteTableAction",
      ec2CreateRouteTableAction
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.RemediationAction
  ) extends zio.aws.fms.model.RemediationAction.ReadOnly {
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val ec2CreateRouteAction
        : Option[zio.aws.fms.model.EC2CreateRouteAction.ReadOnly] = scala
      .Option(impl.ec2CreateRouteAction())
      .map(value => zio.aws.fms.model.EC2CreateRouteAction.wrap(value))
    override val ec2ReplaceRouteAction
        : Option[zio.aws.fms.model.EC2ReplaceRouteAction.ReadOnly] = scala
      .Option(impl.ec2ReplaceRouteAction())
      .map(value => zio.aws.fms.model.EC2ReplaceRouteAction.wrap(value))
    override val ec2DeleteRouteAction
        : Option[zio.aws.fms.model.EC2DeleteRouteAction.ReadOnly] = scala
      .Option(impl.ec2DeleteRouteAction())
      .map(value => zio.aws.fms.model.EC2DeleteRouteAction.wrap(value))
    override val ec2CopyRouteTableAction
        : Option[zio.aws.fms.model.EC2CopyRouteTableAction.ReadOnly] = scala
      .Option(impl.ec2CopyRouteTableAction())
      .map(value => zio.aws.fms.model.EC2CopyRouteTableAction.wrap(value))
    override val ec2ReplaceRouteTableAssociationAction: Option[
      zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.ReadOnly
    ] = scala
      .Option(impl.ec2ReplaceRouteTableAssociationAction())
      .map(value =>
        zio.aws.fms.model.EC2ReplaceRouteTableAssociationAction.wrap(value)
      )
    override val ec2AssociateRouteTableAction
        : Option[zio.aws.fms.model.EC2AssociateRouteTableAction.ReadOnly] =
      scala
        .Option(impl.ec2AssociateRouteTableAction())
        .map(value =>
          zio.aws.fms.model.EC2AssociateRouteTableAction.wrap(value)
        )
    override val ec2CreateRouteTableAction
        : Option[zio.aws.fms.model.EC2CreateRouteTableAction.ReadOnly] = scala
      .Option(impl.ec2CreateRouteTableAction())
      .map(value => zio.aws.fms.model.EC2CreateRouteTableAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.RemediationAction
  ): zio.aws.fms.model.RemediationAction.ReadOnly = new Wrapper(impl)
}
