package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Route(
    destinationType: Option[zio.aws.fms.model.DestinationType] = None,
    targetType: Option[zio.aws.fms.model.TargetType] = None,
    destination: Option[LengthBoundedString] = None,
    target: Option[LengthBoundedString] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.fms.model.Route = {
    import Route.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.Route
      .builder()
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        destination.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.destination)
      .optionallyWith(
        target.map(value => LengthBoundedString.unwrap(value): java.lang.String)
      )(_.target)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.Route.ReadOnly =
    zio.aws.fms.model.Route.wrap(buildAwsValue())
}
object Route {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.Route] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.Route = zio.aws.fms.model.Route(
      destinationType.map(value => value),
      targetType.map(value => value),
      destination.map(value => value),
      target.map(value => value)
    )
    def destinationType: Option[zio.aws.fms.model.DestinationType]
    def targetType: Option[zio.aws.fms.model.TargetType]
    def destination: Option[LengthBoundedString]
    def target: Option[LengthBoundedString]
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.fms.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getTargetType: ZIO[Any, AwsError, zio.aws.fms.model.TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getDestination: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("destination", destination)
    def getTarget: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.Route
  ) extends zio.aws.fms.model.Route.ReadOnly {
    override val destinationType: Option[zio.aws.fms.model.DestinationType] =
      scala
        .Option(impl.destinationType())
        .map(value => zio.aws.fms.model.DestinationType.wrap(value))
    override val targetType: Option[zio.aws.fms.model.TargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.fms.model.TargetType.wrap(value))
    override val destination: Option[LengthBoundedString] = scala
      .Option(impl.destination())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val target: Option[LengthBoundedString] = scala
      .Option(impl.target())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.Route
  ): zio.aws.fms.model.Route.ReadOnly = new Wrapper(impl)
}
