package zio.aws.fms
import zio.prelude.Subtype
import zio.aws.fms.model.primitives.{
  Protocol,
  LengthBoundedString,
  DetailedInfo,
  PreviousListVersion,
  DnsRuleGroupPriority,
  AWSAccountId,
  ResourceType,
  TargetViolationReason,
  CustomerPolicyScopeId,
  NetworkFirewallAction,
  ResourceId,
  TagKey
}
import java.time.Instant
import zio.aws.fms.model.primitives.ManagedServiceData.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSAccountId extends Subtype[String]
    type AWSAccountId = zio.aws.fms.model.primitives.AWSAccountId.Type
    object BasicInteger extends Subtype[Int]
    type BasicInteger = zio.aws.fms.model.primitives.BasicInteger.Type
    object CIDR extends Subtype[String]
    type CIDR = zio.aws.fms.model.primitives.CIDR.Type
    object CustomerPolicyScopeId extends Subtype[String]
    type CustomerPolicyScopeId =
      zio.aws.fms.model.primitives.CustomerPolicyScopeId.Type
    object DetailedInfo extends Subtype[String]
    type DetailedInfo = zio.aws.fms.model.primitives.DetailedInfo.Type
    object DnsRuleGroupPriority extends Subtype[Int]
    type DnsRuleGroupPriority =
      zio.aws.fms.model.primitives.DnsRuleGroupPriority.Type
    object IPPortNumber extends Subtype[Long]
    type IPPortNumber = zio.aws.fms.model.primitives.IPPortNumber.Type
    object LengthBoundedString extends Subtype[String]
    type LengthBoundedString =
      zio.aws.fms.model.primitives.LengthBoundedString.Type
    object ListId extends Subtype[String]
    type ListId = zio.aws.fms.model.primitives.ListId.Type
    object ManagedServiceData extends Subtype[String]
    type ManagedServiceData =
      zio.aws.fms.model.primitives.ManagedServiceData.Type
    object NetworkFirewallAction extends Subtype[String]
    type NetworkFirewallAction =
      zio.aws.fms.model.primitives.NetworkFirewallAction.Type
    object NetworkFirewallResourceName extends Subtype[String]
    type NetworkFirewallResourceName =
      zio.aws.fms.model.primitives.NetworkFirewallResourceName.Type
    object PaginationMaxResults extends Subtype[Int]
    type PaginationMaxResults =
      zio.aws.fms.model.primitives.PaginationMaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.fms.model.primitives.PaginationToken.Type
    object PolicyId extends Subtype[String]
    type PolicyId = zio.aws.fms.model.primitives.PolicyId.Type
    object PolicyUpdateToken extends Subtype[String]
    type PolicyUpdateToken = zio.aws.fms.model.primitives.PolicyUpdateToken.Type
    object PreviousListVersion extends Subtype[String]
    type PreviousListVersion =
      zio.aws.fms.model.primitives.PreviousListVersion.Type
    object ProtectionData extends Subtype[String]
    type ProtectionData = zio.aws.fms.model.primitives.ProtectionData.Type
    object Protocol extends Subtype[String]
    type Protocol = zio.aws.fms.model.primitives.Protocol.Type
    object ReferenceRule extends Subtype[String]
    type ReferenceRule = zio.aws.fms.model.primitives.ReferenceRule.Type
    object RemediationActionDescription extends Subtype[String]
    type RemediationActionDescription =
      zio.aws.fms.model.primitives.RemediationActionDescription.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.fms.model.primitives.ResourceArn.Type
    object ResourceCount extends Subtype[Long]
    type ResourceCount = zio.aws.fms.model.primitives.ResourceCount.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.fms.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.fms.model.primitives.ResourceName.Type
    object ResourceTagKey extends Subtype[String]
    type ResourceTagKey = zio.aws.fms.model.primitives.ResourceTagKey.Type
    object ResourceTagValue extends Subtype[String]
    type ResourceTagValue = zio.aws.fms.model.primitives.ResourceTagValue.Type
    object ResourceType extends Subtype[String]
    type ResourceType = zio.aws.fms.model.primitives.ResourceType.Type
    object StatelessRuleGroupPriority extends Subtype[Int]
    type StatelessRuleGroupPriority =
      zio.aws.fms.model.primitives.StatelessRuleGroupPriority.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.fms.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.fms.model.primitives.TagValue.Type
    object TargetViolationReason extends Subtype[String]
    type TargetViolationReason =
      zio.aws.fms.model.primitives.TargetViolationReason.Type
    object TimeStamp extends Subtype[Instant]
    type TimeStamp = zio.aws.fms.model.primitives.TimeStamp.Type
    object UpdateToken extends Subtype[String]
    type UpdateToken = zio.aws.fms.model.primitives.UpdateToken.Type
    object ViolationTarget extends Subtype[String]
    type ViolationTarget = zio.aws.fms.model.primitives.ViolationTarget.Type
  }
  type AppsList = List[zio.aws.fms.model.App]
  type AppsListsData = List[zio.aws.fms.model.AppsListDataSummary]
  type AwsEc2NetworkInterfaceViolations =
    List[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation]
  type ComplianceViolators = List[zio.aws.fms.model.ComplianceViolator]
  type CustomerPolicyScopeIdList = List[CustomerPolicyScopeId]
  type CustomerPolicyScopeMap =
    Map[zio.aws.fms.model.CustomerPolicyScopeIdType, Iterable[
      CustomerPolicyScopeId
    ]]
  type DnsRuleGroupPriorities = List[DnsRuleGroupPriority]
  type EvaluationResults = List[zio.aws.fms.model.EvaluationResult]
  type ExpectedRoutes = List[zio.aws.fms.model.ExpectedRoute]
  type IssueInfoMap = Map[zio.aws.fms.model.DependentServiceName, DetailedInfo]
  type LengthBoundedStringList = List[LengthBoundedString]
  type MemberAccounts = List[AWSAccountId]
  type NetworkFirewallActionList = List[NetworkFirewallAction]
  type OrderedRemediationActions =
    List[zio.aws.fms.model.RemediationActionWithOrder]
  type PartialMatches = List[zio.aws.fms.model.PartialMatch]
  type PolicyComplianceStatusList =
    List[zio.aws.fms.model.PolicyComplianceStatus]
  type PolicySummaryList = List[zio.aws.fms.model.PolicySummary]
  type PossibleRemediationActionList =
    List[zio.aws.fms.model.PossibleRemediationAction]
  type PreviousAppsList =
    Map[PreviousListVersion, Iterable[zio.aws.fms.model.App]]
  type PreviousProtocolsList = Map[PreviousListVersion, Iterable[Protocol]]
  type ProtocolsList = List[Protocol]
  type ProtocolsListsData = List[zio.aws.fms.model.ProtocolsListDataSummary]
  type ResourceIdList = List[ResourceId]
  type ResourceTags = List[zio.aws.fms.model.ResourceTag]
  type ResourceTypeList = List[ResourceType]
  type ResourceViolations = List[zio.aws.fms.model.ResourceViolation]
  type Routes = List[zio.aws.fms.model.Route]
  type SecurityGroupRemediationActions =
    List[zio.aws.fms.model.SecurityGroupRemediationAction]
  type StatefulRuleGroupList = List[zio.aws.fms.model.StatefulRuleGroup]
  type StatelessRuleGroupList = List[zio.aws.fms.model.StatelessRuleGroup]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.fms.model.Tag]
  type TargetViolationReasons = List[TargetViolationReason]
}
