package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{IPPortNumber, Protocol, ResourceName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class App(
    appName: ResourceName,
    protocol: Protocol,
    port: IPPortNumber
) {
  def buildAwsValue(): software.amazon.awssdk.services.fms.model.App = {
    import App.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.App
      .builder()
      .appName(ResourceName.unwrap(appName): java.lang.String)
      .protocol(Protocol.unwrap(protocol): java.lang.String)
      .port(IPPortNumber.unwrap(port): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.App.ReadOnly =
    zio.aws.fms.model.App.wrap(buildAwsValue())
}
object App {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.App] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.App =
      zio.aws.fms.model.App(appName, protocol, port)
    def appName: ResourceName
    def protocol: Protocol
    def port: IPPortNumber
    def getAppName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(appName)
    def getProtocol: ZIO[Any, Nothing, Protocol] = ZIO.succeed(protocol)
    def getPort: ZIO[Any, Nothing, IPPortNumber] = ZIO.succeed(port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.App
  ) extends zio.aws.fms.model.App.ReadOnly {
    override val appName: ResourceName =
      zio.aws.fms.model.primitives.ResourceName(impl.appName())
    override val protocol: Protocol =
      zio.aws.fms.model.primitives.Protocol(impl.protocol())
    override val port: IPPortNumber =
      zio.aws.fms.model.primitives.IPPortNumber(impl.port())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.App
  ): zio.aws.fms.model.App.ReadOnly = new Wrapper(impl)
}
