package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceId, ViolationTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AwsEc2NetworkInterfaceViolation(
    violationTarget: Option[ViolationTarget] = None,
    violatingSecurityGroups: Option[Iterable[ResourceId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation = {
    import AwsEc2NetworkInterfaceViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        violatingSecurityGroups.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.violatingSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly =
    zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.wrap(buildAwsValue())
}
object AwsEc2NetworkInterfaceViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.AwsEc2NetworkInterfaceViolation =
      zio.aws.fms.model.AwsEc2NetworkInterfaceViolation(
        violationTarget.map(value => value),
        violatingSecurityGroups.map(value => value)
      )
    def violationTarget: Option[ViolationTarget]
    def violatingSecurityGroups: Option[List[ResourceId]]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getViolatingSecurityGroups: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField(
        "violatingSecurityGroups",
        violatingSecurityGroups
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation
  ) extends zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val violatingSecurityGroups: Option[List[ResourceId]] = scala
      .Option(impl.violatingSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.ResourceId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation
  ): zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly = new Wrapper(
    impl
  )
}
