package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait DestinationType {
  def unwrap: software.amazon.awssdk.services.fms.model.DestinationType
}
object DestinationType {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.DestinationType
  ): zio.aws.fms.model.DestinationType = value match {
    case software.amazon.awssdk.services.fms.model.DestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.DestinationType.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.fms.model.DestinationType.IPV6 =>
      val r = IPV6
      r
    case software.amazon.awssdk.services.fms.model.DestinationType.PREFIX_LIST =>
      val r = PREFIX_LIST
      r
  }
  case object unknownToSdkVersion extends zio.aws.fms.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DestinationType =
      software.amazon.awssdk.services.fms.model.DestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4 extends zio.aws.fms.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DestinationType =
      software.amazon.awssdk.services.fms.model.DestinationType.IPV4
  }
  case object IPV6 extends zio.aws.fms.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DestinationType =
      software.amazon.awssdk.services.fms.model.DestinationType.IPV6
  }
  case object PREFIX_LIST extends zio.aws.fms.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.DestinationType =
      software.amazon.awssdk.services.fms.model.DestinationType.PREFIX_LIST
  }
}
