package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.LengthBoundedString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2CopyRouteTableAction(
    description: Option[LengthBoundedString] = None,
    vpcId: zio.aws.fms.model.ActionTarget,
    routeTableId: zio.aws.fms.model.ActionTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EC2CopyRouteTableAction = {
    import EC2CopyRouteTableAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EC2CopyRouteTableAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .vpcId(vpcId.buildAwsValue())
      .routeTableId(routeTableId.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EC2CopyRouteTableAction.ReadOnly =
    zio.aws.fms.model.EC2CopyRouteTableAction.wrap(buildAwsValue())
}
object EC2CopyRouteTableAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EC2CopyRouteTableAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EC2CopyRouteTableAction =
      zio.aws.fms.model.EC2CopyRouteTableAction(
        description.map(value => value),
        vpcId.asEditable,
        routeTableId.asEditable
      )
    def description: Option[LengthBoundedString]
    def vpcId: zio.aws.fms.model.ActionTarget.ReadOnly
    def routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getVpcId: ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(vpcId)
    def getRouteTableId
        : ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EC2CopyRouteTableAction
  ) extends zio.aws.fms.model.EC2CopyRouteTableAction.ReadOnly {
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val vpcId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.vpcId())
    override val routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EC2CopyRouteTableAction
  ): zio.aws.fms.model.EC2CopyRouteTableAction.ReadOnly = new Wrapper(impl)
}
