package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceCount
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EvaluationResult(
    complianceStatus: Option[zio.aws.fms.model.PolicyComplianceStatusType] =
      None,
    violatorCount: Option[ResourceCount] = None,
    evaluationLimitExceeded: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EvaluationResult
      .builder()
      .optionallyWith(complianceStatus.map(value => value.unwrap))(
        _.complianceStatus
      )
      .optionallyWith(
        violatorCount.map(value => ResourceCount.unwrap(value): java.lang.Long)
      )(_.violatorCount)
      .optionallyWith(
        evaluationLimitExceeded.map(value => value: java.lang.Boolean)
      )(_.evaluationLimitExceeded)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EvaluationResult.ReadOnly =
    zio.aws.fms.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EvaluationResult =
      zio.aws.fms.model.EvaluationResult(
        complianceStatus.map(value => value),
        violatorCount.map(value => value),
        evaluationLimitExceeded.map(value => value)
      )
    def complianceStatus: Option[zio.aws.fms.model.PolicyComplianceStatusType]
    def violatorCount: Option[ResourceCount]
    def evaluationLimitExceeded: Option[Boolean]
    def getComplianceStatus
        : ZIO[Any, AwsError, zio.aws.fms.model.PolicyComplianceStatusType] =
      AwsError.unwrapOptionField("complianceStatus", complianceStatus)
    def getViolatorCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("violatorCount", violatorCount)
    def getEvaluationLimitExceeded: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("evaluationLimitExceeded", evaluationLimitExceeded)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EvaluationResult
  ) extends zio.aws.fms.model.EvaluationResult.ReadOnly {
    override val complianceStatus
        : Option[zio.aws.fms.model.PolicyComplianceStatusType] = scala
      .Option(impl.complianceStatus())
      .map(value => zio.aws.fms.model.PolicyComplianceStatusType.wrap(value))
    override val violatorCount: Option[ResourceCount] = scala
      .Option(impl.violatorCount())
      .map(value => zio.aws.fms.model.primitives.ResourceCount(value))
    override val evaluationLimitExceeded: Option[Boolean] =
      scala.Option(impl.evaluationLimitExceeded()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EvaluationResult
  ): zio.aws.fms.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
