package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ListId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetProtocolsListRequest(
    listId: ListId,
    defaultList: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtocolsListRequest = {
    import GetProtocolsListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
      .builder()
      .listId(ListId.unwrap(listId): java.lang.String)
      .optionallyWith(defaultList.map(value => value: java.lang.Boolean))(
        _.defaultList
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtocolsListRequest.ReadOnly =
    zio.aws.fms.model.GetProtocolsListRequest.wrap(buildAwsValue())
}
object GetProtocolsListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtocolsListRequest =
      zio.aws.fms.model
        .GetProtocolsListRequest(listId, defaultList.map(value => value))
    def listId: ListId
    def defaultList: Option[Boolean]
    def getListId: ZIO[Any, Nothing, ListId] = ZIO.succeed(listId)
    def getDefaultList: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultList", defaultList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
  ) extends zio.aws.fms.model.GetProtocolsListRequest.ReadOnly {
    override val listId: ListId =
      zio.aws.fms.model.primitives.ListId(impl.listId())
    override val defaultList: Option[Boolean] =
      scala.Option(impl.defaultList()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListRequest
  ): zio.aws.fms.model.GetProtocolsListRequest.ReadOnly = new Wrapper(impl)
}
