package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetProtocolsListResponse(
    protocolsList: Option[zio.aws.fms.model.ProtocolsListData] = None,
    protocolsListArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtocolsListResponse = {
    import GetProtocolsListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
      .builder()
      .optionallyWith(protocolsList.map(value => value.buildAwsValue()))(
        _.protocolsList
      )
      .optionallyWith(
        protocolsListArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.protocolsListArn)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtocolsListResponse.ReadOnly =
    zio.aws.fms.model.GetProtocolsListResponse.wrap(buildAwsValue())
}
object GetProtocolsListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtocolsListResponse =
      zio.aws.fms.model.GetProtocolsListResponse(
        protocolsList.map(value => value.asEditable),
        protocolsListArn.map(value => value)
      )
    def protocolsList: Option[zio.aws.fms.model.ProtocolsListData.ReadOnly]
    def protocolsListArn: Option[ResourceArn]
    def getProtocolsList
        : ZIO[Any, AwsError, zio.aws.fms.model.ProtocolsListData.ReadOnly] =
      AwsError.unwrapOptionField("protocolsList", protocolsList)
    def getProtocolsListArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("protocolsListArn", protocolsListArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
  ) extends zio.aws.fms.model.GetProtocolsListResponse.ReadOnly {
    override val protocolsList
        : Option[zio.aws.fms.model.ProtocolsListData.ReadOnly] = scala
      .Option(impl.protocolsList())
      .map(value => zio.aws.fms.model.ProtocolsListData.wrap(value))
    override val protocolsListArn: Option[ResourceArn] = scala
      .Option(impl.protocolsListArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtocolsListResponse
  ): zio.aws.fms.model.GetProtocolsListResponse.ReadOnly = new Wrapper(impl)
}
