package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAppsListsResponse(
    appsLists: Option[Iterable[zio.aws.fms.model.AppsListDataSummary]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListAppsListsResponse = {
    import ListAppsListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListAppsListsResponse
      .builder()
      .optionallyWith(
        appsLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appsLists)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListAppsListsResponse.ReadOnly =
    zio.aws.fms.model.ListAppsListsResponse.wrap(buildAwsValue())
}
object ListAppsListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListAppsListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListAppsListsResponse =
      zio.aws.fms.model.ListAppsListsResponse(
        appsLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appsLists: Option[List[zio.aws.fms.model.AppsListDataSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getAppsLists: ZIO[Any, AwsError, List[
      zio.aws.fms.model.AppsListDataSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("appsLists", appsLists)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListAppsListsResponse
  ) extends zio.aws.fms.model.ListAppsListsResponse.ReadOnly {
    override val appsLists
        : Option[List[zio.aws.fms.model.AppsListDataSummary.ReadOnly]] = scala
      .Option(impl.appsLists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.AppsListDataSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListAppsListsResponse
  ): zio.aws.fms.model.ListAppsListsResponse.ReadOnly = new Wrapper(impl)
}
