package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListComplianceStatusResponse(
    policyComplianceStatusList: Option[
      Iterable[zio.aws.fms.model.PolicyComplianceStatus]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse = {
    import ListComplianceStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse
      .builder()
      .optionallyWith(
        policyComplianceStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyComplianceStatusList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly =
    zio.aws.fms.model.ListComplianceStatusResponse.wrap(buildAwsValue())
}
object ListComplianceStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListComplianceStatusResponse =
      zio.aws.fms.model.ListComplianceStatusResponse(
        policyComplianceStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def policyComplianceStatusList
        : Option[List[zio.aws.fms.model.PolicyComplianceStatus.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getPolicyComplianceStatusList: ZIO[Any, AwsError, List[
      zio.aws.fms.model.PolicyComplianceStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "policyComplianceStatusList",
      policyComplianceStatusList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse
  ) extends zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly {
    override val policyComplianceStatusList
        : Option[List[zio.aws.fms.model.PolicyComplianceStatus.ReadOnly]] =
      scala
        .Option(impl.policyComplianceStatusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.PolicyComplianceStatus.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse
  ): zio.aws.fms.model.ListComplianceStatusResponse.ReadOnly = new Wrapper(impl)
}
