package zio.aws.fms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.fms.model.primitives.{PaginationMaxResults, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProtocolsListsRequest(
    defaultLists: Option[Boolean] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: PaginationMaxResults
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest = {
    import ListProtocolsListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest
      .builder()
      .optionallyWith(defaultLists.map(value => value: java.lang.Boolean))(
        _.defaultLists
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .maxResults(PaginationMaxResults.unwrap(maxResults): Integer)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListProtocolsListsRequest.ReadOnly =
    zio.aws.fms.model.ListProtocolsListsRequest.wrap(buildAwsValue())
}
object ListProtocolsListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListProtocolsListsRequest =
      zio.aws.fms.model.ListProtocolsListsRequest(
        defaultLists.map(value => value),
        nextToken.map(value => value),
        maxResults
      )
    def defaultLists: Option[Boolean]
    def nextToken: Option[PaginationToken]
    def maxResults: PaginationMaxResults
    def getDefaultLists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("defaultLists", defaultLists)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, Nothing, PaginationMaxResults] =
      ZIO.succeed(maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest
  ) extends zio.aws.fms.model.ListProtocolsListsRequest.ReadOnly {
    override val defaultLists: Option[Boolean] =
      scala.Option(impl.defaultLists()).map(value => value: Boolean)
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: PaginationMaxResults =
      zio.aws.fms.model.primitives.PaginationMaxResults(impl.maxResults())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListProtocolsListsRequest
  ): zio.aws.fms.model.ListProtocolsListsRequest.ReadOnly = new Wrapper(impl)
}
