package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallInternetTrafficNotInspectedViolation(
    subnetId: Option[ResourceId] = None,
    subnetAvailabilityZone: Option[LengthBoundedString] = None,
    routeTableId: Option[ResourceId] = None,
    violatingRoutes: Option[Iterable[zio.aws.fms.model.Route]] = None,
    isRouteTableUsedInDifferentAZ: Option[Boolean] = None,
    currentFirewallSubnetRouteTable: Option[ResourceId] = None,
    expectedFirewallEndpoint: Option[ResourceId] = None,
    firewallSubnetId: Option[ResourceId] = None,
    expectedFirewallSubnetRoutes: Option[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = None,
    actualFirewallSubnetRoutes: Option[Iterable[zio.aws.fms.model.Route]] =
      None,
    internetGatewayId: Option[ResourceId] = None,
    currentInternetGatewayRouteTable: Option[ResourceId] = None,
    expectedInternetGatewayRoutes: Option[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = None,
    actualInternetGatewayRoutes: Option[Iterable[zio.aws.fms.model.Route]] =
      None,
    vpcId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation = {
    import NetworkFirewallInternetTrafficNotInspectedViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
      .builder()
      .optionallyWith(
        subnetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        subnetAvailabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        violatingRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.violatingRoutes)
      .optionallyWith(
        isRouteTableUsedInDifferentAZ.map(value => value: java.lang.Boolean)
      )(_.isRouteTableUsedInDifferentAZ)
      .optionallyWith(
        currentFirewallSubnetRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentFirewallSubnetRouteTable)
      .optionallyWith(
        expectedFirewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedFirewallEndpoint)
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedFirewallSubnetRoutes)
      .optionallyWith(
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualFirewallSubnetRoutes)
      .optionallyWith(
        internetGatewayId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.internetGatewayId)
      .optionallyWith(
        currentInternetGatewayRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentInternetGatewayRouteTable)
      .optionallyWith(
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedInternetGatewayRoutes)
      .optionallyWith(
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualInternetGatewayRoutes)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallInternetTrafficNotInspectedViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation =
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation(
        subnetId.map(value => value),
        subnetAvailabilityZone.map(value => value),
        routeTableId.map(value => value),
        violatingRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isRouteTableUsedInDifferentAZ.map(value => value),
        currentFirewallSubnetRouteTable.map(value => value),
        expectedFirewallEndpoint.map(value => value),
        firewallSubnetId.map(value => value),
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        currentInternetGatewayRouteTable.map(value => value),
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def subnetId: Option[ResourceId]
    def subnetAvailabilityZone: Option[LengthBoundedString]
    def routeTableId: Option[ResourceId]
    def violatingRoutes: Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def isRouteTableUsedInDifferentAZ: Option[Boolean]
    def currentFirewallSubnetRouteTable: Option[ResourceId]
    def expectedFirewallEndpoint: Option[ResourceId]
    def firewallSubnetId: Option[ResourceId]
    def expectedFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def internetGatewayId: Option[ResourceId]
    def currentInternetGatewayRouteTable: Option[ResourceId]
    def expectedInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def vpcId: Option[ResourceId]
    def getSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getViolatingRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField("violatingRoutes", violatingRoutes)
    def getIsRouteTableUsedInDifferentAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isRouteTableUsedInDifferentAZ",
        isRouteTableUsedInDifferentAZ
      )
    def getCurrentFirewallSubnetRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentFirewallSubnetRouteTable",
        currentFirewallSubnetRouteTable
      )
    def getExpectedFirewallEndpoint: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("expectedFirewallEndpoint", expectedFirewallEndpoint)
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getExpectedFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedFirewallSubnetRoutes",
        expectedFirewallSubnetRoutes
      )
    def getActualFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualFirewallSubnetRoutes",
        actualFirewallSubnetRoutes
      )
    def getInternetGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getCurrentInternetGatewayRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentInternetGatewayRouteTable",
        currentInternetGatewayRouteTable
      )
    def getExpectedInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedInternetGatewayRoutes",
        expectedInternetGatewayRoutes
      )
    def getActualInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualInternetGatewayRoutes",
        actualInternetGatewayRoutes
      )
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
  ) extends zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly {
    override val subnetId: Option[ResourceId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val subnetAvailabilityZone: Option[LengthBoundedString] = scala
      .Option(impl.subnetAvailabilityZone())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val routeTableId: Option[ResourceId] = scala
      .Option(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val violatingRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.violatingRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val isRouteTableUsedInDifferentAZ: Option[Boolean] = scala
      .Option(impl.isRouteTableUsedInDifferentAZ())
      .map(value => value: Boolean)
    override val currentFirewallSubnetRouteTable: Option[ResourceId] = scala
      .Option(impl.currentFirewallSubnetRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallEndpoint: Option[ResourceId] = scala
      .Option(impl.expectedFirewallEndpoint())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val firewallSubnetId: Option[ResourceId] = scala
      .Option(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] = scala
      .Option(impl.expectedFirewallSubnetRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.ExpectedRoute.wrap(item)
        }.toList
      )
    override val actualFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.actualFirewallSubnetRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val internetGatewayId: Option[ResourceId] = scala
      .Option(impl.internetGatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val currentInternetGatewayRouteTable: Option[ResourceId] = scala
      .Option(impl.currentInternetGatewayRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] = scala
      .Option(impl.expectedInternetGatewayRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.ExpectedRoute.wrap(item)
        }.toList
      )
    override val actualInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.actualInternetGatewayRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
  ): zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly =
    new Wrapper(impl)
}
