package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  LengthBoundedString,
  ResourceId,
  ViolationTarget
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallMissingExpectedRTViolation(
    violationTarget: Option[ViolationTarget] = None,
    vpc: Option[ResourceId] = None,
    availabilityZone: Option[LengthBoundedString] = None,
    currentRouteTable: Option[ResourceId] = None,
    expectedRouteTable: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation = {
    import NetworkFirewallMissingExpectedRTViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        vpc.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpc)
      .optionallyWith(
        availabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        currentRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentRouteTable)
      .optionallyWith(
        expectedRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedRouteTable)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallMissingExpectedRTViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation =
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation(
        violationTarget.map(value => value),
        vpc.map(value => value),
        availabilityZone.map(value => value),
        currentRouteTable.map(value => value),
        expectedRouteTable.map(value => value)
      )
    def violationTarget: Option[ViolationTarget]
    def vpc: Option[ResourceId]
    def availabilityZone: Option[LengthBoundedString]
    def currentRouteTable: Option[ResourceId]
    def expectedRouteTable: Option[ResourceId]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getVpc: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCurrentRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("currentRouteTable", currentRouteTable)
    def getExpectedRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("expectedRouteTable", expectedRouteTable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation
  ) extends zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val vpc: Option[ResourceId] = scala
      .Option(impl.vpc())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val availabilityZone: Option[LengthBoundedString] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val currentRouteTable: Option[ResourceId] = scala
      .Option(impl.currentRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedRouteTable: Option[ResourceId] = scala
      .Option(impl.expectedRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation
  ): zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly =
    new Wrapper(impl)
}
