package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{TargetViolationReason, ReferenceRule}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PartialMatch(
    reference: Option[ReferenceRule] = None,
    targetViolationReasons: Option[Iterable[TargetViolationReason]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PartialMatch = {
    import PartialMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PartialMatch
      .builder()
      .optionallyWith(
        reference.map(value => ReferenceRule.unwrap(value): java.lang.String)
      )(_.reference)
      .optionallyWith(
        targetViolationReasons.map(value =>
          value.map { item =>
            TargetViolationReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetViolationReasons)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PartialMatch.ReadOnly =
    zio.aws.fms.model.PartialMatch.wrap(buildAwsValue())
}
object PartialMatch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.PartialMatch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PartialMatch =
      zio.aws.fms.model.PartialMatch(
        reference.map(value => value),
        targetViolationReasons.map(value => value)
      )
    def reference: Option[ReferenceRule]
    def targetViolationReasons: Option[List[TargetViolationReason]]
    def getReference: ZIO[Any, AwsError, ReferenceRule] =
      AwsError.unwrapOptionField("reference", reference)
    def getTargetViolationReasons
        : ZIO[Any, AwsError, List[TargetViolationReason]] = AwsError
      .unwrapOptionField("targetViolationReasons", targetViolationReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PartialMatch
  ) extends zio.aws.fms.model.PartialMatch.ReadOnly {
    override val reference: Option[ReferenceRule] = scala
      .Option(impl.reference())
      .map(value => zio.aws.fms.model.primitives.ReferenceRule(value))
    override val targetViolationReasons: Option[List[TargetViolationReason]] =
      scala
        .Option(impl.targetViolationReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.primitives.TargetViolationReason(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PartialMatch
  ): zio.aws.fms.model.PartialMatch.ReadOnly = new Wrapper(impl)
}
