package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  ResourceType,
  ResourceName,
  PolicyId,
  ResourceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PolicySummary(
    policyArn: Option[ResourceArn] = None,
    policyId: Option[PolicyId] = None,
    policyName: Option[ResourceName] = None,
    resourceType: Option[ResourceType] = None,
    securityServiceType: Option[zio.aws.fms.model.SecurityServiceType] = None,
    remediationEnabled: Option[Boolean] = None,
    deleteUnusedFMManagedResources: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PolicySummary = {
    import PolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PolicySummary
      .builder()
      .optionallyWith(
        policyArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(securityServiceType.map(value => value.unwrap))(
        _.securityServiceType
      )
      .optionallyWith(
        remediationEnabled.map(value => value: java.lang.Boolean)
      )(_.remediationEnabled)
      .optionallyWith(
        deleteUnusedFMManagedResources.map(value => value: java.lang.Boolean)
      )(_.deleteUnusedFMManagedResources)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PolicySummary.ReadOnly =
    zio.aws.fms.model.PolicySummary.wrap(buildAwsValue())
}
object PolicySummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fms.model.PolicySummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PolicySummary =
      zio.aws.fms.model.PolicySummary(
        policyArn.map(value => value),
        policyId.map(value => value),
        policyName.map(value => value),
        resourceType.map(value => value),
        securityServiceType.map(value => value),
        remediationEnabled.map(value => value),
        deleteUnusedFMManagedResources.map(value => value)
      )
    def policyArn: Option[ResourceArn]
    def policyId: Option[PolicyId]
    def policyName: Option[ResourceName]
    def resourceType: Option[ResourceType]
    def securityServiceType: Option[zio.aws.fms.model.SecurityServiceType]
    def remediationEnabled: Option[Boolean]
    def deleteUnusedFMManagedResources: Option[Boolean]
    def getPolicyArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSecurityServiceType
        : ZIO[Any, AwsError, zio.aws.fms.model.SecurityServiceType] =
      AwsError.unwrapOptionField("securityServiceType", securityServiceType)
    def getRemediationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remediationEnabled", remediationEnabled)
    def getDeleteUnusedFMManagedResources: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "deleteUnusedFMManagedResources",
        deleteUnusedFMManagedResources
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PolicySummary
  ) extends zio.aws.fms.model.PolicySummary.ReadOnly {
    override val policyArn: Option[ResourceArn] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.fms.model.primitives.ResourceArn(value))
    override val policyId: Option[PolicyId] = scala
      .Option(impl.policyId())
      .map(value => zio.aws.fms.model.primitives.PolicyId(value))
    override val policyName: Option[ResourceName] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.fms.model.primitives.ResourceName(value))
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.fms.model.primitives.ResourceType(value))
    override val securityServiceType
        : Option[zio.aws.fms.model.SecurityServiceType] = scala
      .Option(impl.securityServiceType())
      .map(value => zio.aws.fms.model.SecurityServiceType.wrap(value))
    override val remediationEnabled: Option[Boolean] =
      scala.Option(impl.remediationEnabled()).map(value => value: Boolean)
    override val deleteUnusedFMManagedResources: Option[Boolean] = scala
      .Option(impl.deleteUnusedFMManagedResources())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PolicySummary
  ): zio.aws.fms.model.PolicySummary.ReadOnly = new Wrapper(impl)
}
