package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutNotificationChannelRequest(
    snsTopicArn: ResourceArn,
    snsRoleName: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest = {
    import PutNotificationChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest
      .builder()
      .snsTopicArn(ResourceArn.unwrap(snsTopicArn): java.lang.String)
      .snsRoleName(ResourceArn.unwrap(snsRoleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.PutNotificationChannelRequest.ReadOnly =
    zio.aws.fms.model.PutNotificationChannelRequest.wrap(buildAwsValue())
}
object PutNotificationChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.PutNotificationChannelRequest =
      zio.aws.fms.model.PutNotificationChannelRequest(snsTopicArn, snsRoleName)
    def snsTopicArn: ResourceArn
    def snsRoleName: ResourceArn
    def getSnsTopicArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(snsTopicArn)
    def getSnsRoleName: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(snsRoleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest
  ) extends zio.aws.fms.model.PutNotificationChannelRequest.ReadOnly {
    override val snsTopicArn: ResourceArn =
      zio.aws.fms.model.primitives.ResourceArn(impl.snsTopicArn())
    override val snsRoleName: ResourceArn =
      zio.aws.fms.model.primitives.ResourceArn(impl.snsRoleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest
  ): zio.aws.fms.model.PutNotificationChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
