package zio.aws.fms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceViolation(
    awsVPCSecurityGroupViolation: Option[
      zio.aws.fms.model.AwsVPCSecurityGroupViolation
    ] = None,
    awsEc2NetworkInterfaceViolation: Option[
      zio.aws.fms.model.AwsEc2NetworkInterfaceViolation
    ] = None,
    awsEc2InstanceViolation: Option[zio.aws.fms.model.AwsEc2InstanceViolation] =
      None,
    networkFirewallMissingFirewallViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation
    ] = None,
    networkFirewallMissingSubnetViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation
    ] = None,
    networkFirewallMissingExpectedRTViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation
    ] = None,
    networkFirewallPolicyModifiedViolation: Option[
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation
    ] = None,
    networkFirewallInternetTrafficNotInspectedViolation: Option[
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
    ] = None,
    networkFirewallInvalidRouteConfigurationViolation: Option[
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
    ] = None,
    networkFirewallBlackHoleRouteDetectedViolation: Option[
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
    ] = None,
    networkFirewallUnexpectedFirewallRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
    ] = None,
    networkFirewallUnexpectedGatewayRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
    ] = None,
    networkFirewallMissingExpectedRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation
    ] = None,
    dnsRuleGroupPriorityConflictViolation: Option[
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation
    ] = None,
    dnsDuplicateRuleGroupViolation: Option[
      zio.aws.fms.model.DnsDuplicateRuleGroupViolation
    ] = None,
    dnsRuleGroupLimitExceededViolation: Option[
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation
    ] = None,
    possibleRemediationActions: Option[
      zio.aws.fms.model.PossibleRemediationActions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ResourceViolation = {
    import ResourceViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ResourceViolation
      .builder()
      .optionallyWith(
        awsVPCSecurityGroupViolation.map(value => value.buildAwsValue())
      )(_.awsVPCSecurityGroupViolation)
      .optionallyWith(
        awsEc2NetworkInterfaceViolation.map(value => value.buildAwsValue())
      )(_.awsEc2NetworkInterfaceViolation)
      .optionallyWith(
        awsEc2InstanceViolation.map(value => value.buildAwsValue())
      )(_.awsEc2InstanceViolation)
      .optionallyWith(
        networkFirewallMissingFirewallViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingFirewallViolation)
      .optionallyWith(
        networkFirewallMissingSubnetViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingSubnetViolation)
      .optionallyWith(
        networkFirewallMissingExpectedRTViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingExpectedRTViolation)
      .optionallyWith(
        networkFirewallPolicyModifiedViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallPolicyModifiedViolation)
      .optionallyWith(
        networkFirewallInternetTrafficNotInspectedViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallInternetTrafficNotInspectedViolation)
      .optionallyWith(
        networkFirewallInvalidRouteConfigurationViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallInvalidRouteConfigurationViolation)
      .optionallyWith(
        networkFirewallBlackHoleRouteDetectedViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallBlackHoleRouteDetectedViolation)
      .optionallyWith(
        networkFirewallUnexpectedFirewallRoutesViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallUnexpectedFirewallRoutesViolation)
      .optionallyWith(
        networkFirewallUnexpectedGatewayRoutesViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallUnexpectedGatewayRoutesViolation)
      .optionallyWith(
        networkFirewallMissingExpectedRoutesViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.networkFirewallMissingExpectedRoutesViolation)
      .optionallyWith(
        dnsRuleGroupPriorityConflictViolation.map(value =>
          value.buildAwsValue()
        )
      )(_.dnsRuleGroupPriorityConflictViolation)
      .optionallyWith(
        dnsDuplicateRuleGroupViolation.map(value => value.buildAwsValue())
      )(_.dnsDuplicateRuleGroupViolation)
      .optionallyWith(
        dnsRuleGroupLimitExceededViolation.map(value => value.buildAwsValue())
      )(_.dnsRuleGroupLimitExceededViolation)
      .optionallyWith(
        possibleRemediationActions.map(value => value.buildAwsValue())
      )(_.possibleRemediationActions)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ResourceViolation.ReadOnly =
    zio.aws.fms.model.ResourceViolation.wrap(buildAwsValue())
}
object ResourceViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ResourceViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ResourceViolation =
      zio.aws.fms.model.ResourceViolation(
        awsVPCSecurityGroupViolation.map(value => value.asEditable),
        awsEc2NetworkInterfaceViolation.map(value => value.asEditable),
        awsEc2InstanceViolation.map(value => value.asEditable),
        networkFirewallMissingFirewallViolation.map(value => value.asEditable),
        networkFirewallMissingSubnetViolation.map(value => value.asEditable),
        networkFirewallMissingExpectedRTViolation.map(value =>
          value.asEditable
        ),
        networkFirewallPolicyModifiedViolation.map(value => value.asEditable),
        networkFirewallInternetTrafficNotInspectedViolation.map(value =>
          value.asEditable
        ),
        networkFirewallInvalidRouteConfigurationViolation.map(value =>
          value.asEditable
        ),
        networkFirewallBlackHoleRouteDetectedViolation.map(value =>
          value.asEditable
        ),
        networkFirewallUnexpectedFirewallRoutesViolation.map(value =>
          value.asEditable
        ),
        networkFirewallUnexpectedGatewayRoutesViolation.map(value =>
          value.asEditable
        ),
        networkFirewallMissingExpectedRoutesViolation.map(value =>
          value.asEditable
        ),
        dnsRuleGroupPriorityConflictViolation.map(value => value.asEditable),
        dnsDuplicateRuleGroupViolation.map(value => value.asEditable),
        dnsRuleGroupLimitExceededViolation.map(value => value.asEditable),
        possibleRemediationActions.map(value => value.asEditable)
      )
    def awsVPCSecurityGroupViolation
        : Option[zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly]
    def awsEc2NetworkInterfaceViolation
        : Option[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly]
    def awsEc2InstanceViolation
        : Option[zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly]
    def networkFirewallMissingFirewallViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly
    ]
    def networkFirewallMissingSubnetViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.ReadOnly
    ]
    def networkFirewallMissingExpectedRTViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly
    ]
    def networkFirewallPolicyModifiedViolation: Option[
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly
    ]
    def networkFirewallInternetTrafficNotInspectedViolation: Option[
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly
    ]
    def networkFirewallInvalidRouteConfigurationViolation: Option[
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly
    ]
    def networkFirewallBlackHoleRouteDetectedViolation: Option[
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly
    ]
    def networkFirewallUnexpectedFirewallRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly
    ]
    def networkFirewallUnexpectedGatewayRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly
    ]
    def networkFirewallMissingExpectedRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly
    ]
    def dnsRuleGroupPriorityConflictViolation: Option[
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly
    ]
    def dnsDuplicateRuleGroupViolation
        : Option[zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly]
    def dnsRuleGroupLimitExceededViolation
        : Option[zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly]
    def possibleRemediationActions
        : Option[zio.aws.fms.model.PossibleRemediationActions.ReadOnly]
    def getAwsVPCSecurityGroupViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsVPCSecurityGroupViolation",
      awsVPCSecurityGroupViolation
    )
    def getAwsEc2NetworkInterfaceViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEc2NetworkInterfaceViolation",
      awsEc2NetworkInterfaceViolation
    )
    def getAwsEc2InstanceViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsEc2InstanceViolation",
      awsEc2InstanceViolation
    )
    def getNetworkFirewallMissingFirewallViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingFirewallViolation",
      networkFirewallMissingFirewallViolation
    )
    def getNetworkFirewallMissingSubnetViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingSubnetViolation",
      networkFirewallMissingSubnetViolation
    )
    def getNetworkFirewallMissingExpectedRTViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingExpectedRTViolation",
      networkFirewallMissingExpectedRTViolation
    )
    def getNetworkFirewallPolicyModifiedViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallPolicyModifiedViolation",
      networkFirewallPolicyModifiedViolation
    )
    def getNetworkFirewallInternetTrafficNotInspectedViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallInternetTrafficNotInspectedViolation",
      networkFirewallInternetTrafficNotInspectedViolation
    )
    def getNetworkFirewallInvalidRouteConfigurationViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallInvalidRouteConfigurationViolation",
      networkFirewallInvalidRouteConfigurationViolation
    )
    def getNetworkFirewallBlackHoleRouteDetectedViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallBlackHoleRouteDetectedViolation",
      networkFirewallBlackHoleRouteDetectedViolation
    )
    def getNetworkFirewallUnexpectedFirewallRoutesViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallUnexpectedFirewallRoutesViolation",
      networkFirewallUnexpectedFirewallRoutesViolation
    )
    def getNetworkFirewallUnexpectedGatewayRoutesViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallUnexpectedGatewayRoutesViolation",
      networkFirewallUnexpectedGatewayRoutesViolation
    )
    def getNetworkFirewallMissingExpectedRoutesViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkFirewallMissingExpectedRoutesViolation",
      networkFirewallMissingExpectedRoutesViolation
    )
    def getDnsRuleGroupPriorityConflictViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsRuleGroupPriorityConflictViolation",
      dnsRuleGroupPriorityConflictViolation
    )
    def getDnsDuplicateRuleGroupViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsDuplicateRuleGroupViolation",
      dnsDuplicateRuleGroupViolation
    )
    def getDnsRuleGroupLimitExceededViolation: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsRuleGroupLimitExceededViolation",
      dnsRuleGroupLimitExceededViolation
    )
    def getPossibleRemediationActions: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.PossibleRemediationActions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "possibleRemediationActions",
      possibleRemediationActions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ResourceViolation
  ) extends zio.aws.fms.model.ResourceViolation.ReadOnly {
    override val awsVPCSecurityGroupViolation
        : Option[zio.aws.fms.model.AwsVPCSecurityGroupViolation.ReadOnly] =
      scala
        .Option(impl.awsVPCSecurityGroupViolation())
        .map(value =>
          zio.aws.fms.model.AwsVPCSecurityGroupViolation.wrap(value)
        )
    override val awsEc2NetworkInterfaceViolation
        : Option[zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.ReadOnly] =
      scala
        .Option(impl.awsEc2NetworkInterfaceViolation())
        .map(value =>
          zio.aws.fms.model.AwsEc2NetworkInterfaceViolation.wrap(value)
        )
    override val awsEc2InstanceViolation
        : Option[zio.aws.fms.model.AwsEc2InstanceViolation.ReadOnly] = scala
      .Option(impl.awsEc2InstanceViolation())
      .map(value => zio.aws.fms.model.AwsEc2InstanceViolation.wrap(value))
    override val networkFirewallMissingFirewallViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallMissingFirewallViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.wrap(value)
      )
    override val networkFirewallMissingSubnetViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallMissingSubnetViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingSubnetViolation.wrap(value)
      )
    override val networkFirewallMissingExpectedRTViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallMissingExpectedRTViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingExpectedRTViolation.wrap(value)
      )
    override val networkFirewallPolicyModifiedViolation: Option[
      zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallPolicyModifiedViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallPolicyModifiedViolation.wrap(value)
      )
    override val networkFirewallInternetTrafficNotInspectedViolation: Option[
      zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallInternetTrafficNotInspectedViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation
          .wrap(value)
      )
    override val networkFirewallInvalidRouteConfigurationViolation: Option[
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallInvalidRouteConfigurationViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
          .wrap(value)
      )
    override val networkFirewallBlackHoleRouteDetectedViolation: Option[
      zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallBlackHoleRouteDetectedViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation
          .wrap(value)
      )
    override val networkFirewallUnexpectedFirewallRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallUnexpectedFirewallRoutesViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation
          .wrap(value)
      )
    override val networkFirewallUnexpectedGatewayRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallUnexpectedGatewayRoutesViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation
          .wrap(value)
      )
    override val networkFirewallMissingExpectedRoutesViolation: Option[
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly
    ] = scala
      .Option(impl.networkFirewallMissingExpectedRoutesViolation())
      .map(value =>
        zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation
          .wrap(value)
      )
    override val dnsRuleGroupPriorityConflictViolation: Option[
      zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.ReadOnly
    ] = scala
      .Option(impl.dnsRuleGroupPriorityConflictViolation())
      .map(value =>
        zio.aws.fms.model.DnsRuleGroupPriorityConflictViolation.wrap(value)
      )
    override val dnsDuplicateRuleGroupViolation
        : Option[zio.aws.fms.model.DnsDuplicateRuleGroupViolation.ReadOnly] =
      scala
        .Option(impl.dnsDuplicateRuleGroupViolation())
        .map(value =>
          zio.aws.fms.model.DnsDuplicateRuleGroupViolation.wrap(value)
        )
    override val dnsRuleGroupLimitExceededViolation: Option[
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly
    ] = scala
      .Option(impl.dnsRuleGroupLimitExceededViolation())
      .map(value =>
        zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.wrap(value)
      )
    override val possibleRemediationActions
        : Option[zio.aws.fms.model.PossibleRemediationActions.ReadOnly] = scala
      .Option(impl.possibleRemediationActions())
      .map(value => zio.aws.fms.model.PossibleRemediationActions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ResourceViolation
  ): zio.aws.fms.model.ResourceViolation.ReadOnly = new Wrapper(impl)
}
