package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.RemediationActionDescription
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SecurityGroupRemediationAction(
    remediationActionType: Option[zio.aws.fms.model.RemediationActionType] =
      None,
    description: Option[RemediationActionDescription] = None,
    remediationResult: Option[zio.aws.fms.model.SecurityGroupRuleDescription] =
      None,
    isDefaultAction: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction = {
    import SecurityGroupRemediationAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
      .builder()
      .optionallyWith(remediationActionType.map(value => value.unwrap))(
        _.remediationActionType
      )
      .optionallyWith(
        description.map(value =>
          RemediationActionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(remediationResult.map(value => value.buildAwsValue()))(
        _.remediationResult
      )
      .optionallyWith(isDefaultAction.map(value => value: java.lang.Boolean))(
        _.isDefaultAction
      )
      .build()
  }
  def asReadOnly: zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly =
    zio.aws.fms.model.SecurityGroupRemediationAction.wrap(buildAwsValue())
}
object SecurityGroupRemediationAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.SecurityGroupRemediationAction =
      zio.aws.fms.model.SecurityGroupRemediationAction(
        remediationActionType.map(value => value),
        description.map(value => value),
        remediationResult.map(value => value.asEditable),
        isDefaultAction.map(value => value)
      )
    def remediationActionType: Option[zio.aws.fms.model.RemediationActionType]
    def description: Option[RemediationActionDescription]
    def remediationResult
        : Option[zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly]
    def isDefaultAction: Option[Boolean]
    def getRemediationActionType
        : ZIO[Any, AwsError, zio.aws.fms.model.RemediationActionType] =
      AwsError.unwrapOptionField("remediationActionType", remediationActionType)
    def getDescription: ZIO[Any, AwsError, RemediationActionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRemediationResult: ZIO[
      Any,
      AwsError,
      zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly
    ] = AwsError.unwrapOptionField("remediationResult", remediationResult)
    def getIsDefaultAction: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefaultAction", isDefaultAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
  ) extends zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly {
    override val remediationActionType
        : Option[zio.aws.fms.model.RemediationActionType] = scala
      .Option(impl.remediationActionType())
      .map(value => zio.aws.fms.model.RemediationActionType.wrap(value))
    override val description: Option[RemediationActionDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.fms.model.primitives.RemediationActionDescription(value)
      )
    override val remediationResult
        : Option[zio.aws.fms.model.SecurityGroupRuleDescription.ReadOnly] =
      scala
        .Option(impl.remediationResult())
        .map(value =>
          zio.aws.fms.model.SecurityGroupRuleDescription.wrap(value)
        )
    override val isDefaultAction: Option[Boolean] =
      scala.Option(impl.isDefaultAction()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.SecurityGroupRemediationAction
  ): zio.aws.fms.model.SecurityGroupRemediationAction.ReadOnly = new Wrapper(
    impl
  )
}
