package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tagList: Iterable[zio.aws.fms.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.TagResourceRequest.ReadOnly =
    zio.aws.fms.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.TagResourceRequest =
      zio.aws.fms.model.TagResourceRequest(
        resourceArn,
        tagList.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tagList: List[zio.aws.fms.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagList: ZIO[Any, Nothing, List[zio.aws.fms.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.TagResourceRequest
  ) extends zio.aws.fms.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.fms.model.primitives.ResourceArn(impl.resourceArn())
    override val tagList: List[zio.aws.fms.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.fms.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.TagResourceRequest
  ): zio.aws.fms.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
