package zio.aws.fms.model
import scala.jdk.CollectionConverters.*
sealed trait CustomerPolicyScopeIdType {
  def unwrap
      : software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType
}
object CustomerPolicyScopeIdType {
  def wrap(
      value: software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType
  ): zio.aws.fms.model.CustomerPolicyScopeIdType = value match {
    case software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType.ORG_UNIT =>
      val r = ORG_UNIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fms.model.CustomerPolicyScopeIdType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType =
      software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT extends zio.aws.fms.model.CustomerPolicyScopeIdType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType =
      software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType.ACCOUNT
  }
  case object ORG_UNIT extends zio.aws.fms.model.CustomerPolicyScopeIdType {
    override def unwrap
        : software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType =
      software.amazon.awssdk.services.fms.model.CustomerPolicyScopeIdType.ORG_UNIT
  }
}
