package zio.aws.fms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.fms.model.primitives.{
  BasicInteger,
  LengthBoundedString,
  ViolationTarget
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DnsRuleGroupLimitExceededViolation(
    violationTarget: Option[ViolationTarget] = None,
    violationTargetDescription: Option[LengthBoundedString] = None,
    numberOfRuleGroupsAlreadyAssociated: Option[BasicInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.DnsRuleGroupLimitExceededViolation = {
    import DnsRuleGroupLimitExceededViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.DnsRuleGroupLimitExceededViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        violationTargetDescription.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.violationTargetDescription)
      .optionallyWith(
        numberOfRuleGroupsAlreadyAssociated.map(value =>
          BasicInteger.unwrap(value): Integer
        )
      )(_.numberOfRuleGroupsAlreadyAssociated)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly =
    zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.wrap(buildAwsValue())
}
object DnsRuleGroupLimitExceededViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.DnsRuleGroupLimitExceededViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.DnsRuleGroupLimitExceededViolation =
      zio.aws.fms.model.DnsRuleGroupLimitExceededViolation(
        violationTarget.map(value => value),
        violationTargetDescription.map(value => value),
        numberOfRuleGroupsAlreadyAssociated.map(value => value)
      )
    def violationTarget: Option[ViolationTarget]
    def violationTargetDescription: Option[LengthBoundedString]
    def numberOfRuleGroupsAlreadyAssociated: Option[BasicInteger]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getViolationTargetDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "violationTargetDescription",
        violationTargetDescription
      )
    def getNumberOfRuleGroupsAlreadyAssociated
        : ZIO[Any, AwsError, BasicInteger] = AwsError.unwrapOptionField(
      "numberOfRuleGroupsAlreadyAssociated",
      numberOfRuleGroupsAlreadyAssociated
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.DnsRuleGroupLimitExceededViolation
  ) extends zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val violationTargetDescription: Option[LengthBoundedString] = scala
      .Option(impl.violationTargetDescription())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val numberOfRuleGroupsAlreadyAssociated: Option[BasicInteger] =
      scala
        .Option(impl.numberOfRuleGroupsAlreadyAssociated())
        .map(value => zio.aws.fms.model.primitives.BasicInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.DnsRuleGroupLimitExceededViolation
  ): zio.aws.fms.model.DnsRuleGroupLimitExceededViolation.ReadOnly =
    new Wrapper(impl)
}
