package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceId, CIDR, LengthBoundedString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EC2ReplaceRouteAction(
    description: Option[LengthBoundedString] = None,
    destinationCidrBlock: Option[CIDR] = None,
    destinationPrefixListId: Option[ResourceId] = None,
    destinationIpv6CidrBlock: Option[CIDR] = None,
    gatewayId: Option[zio.aws.fms.model.ActionTarget] = None,
    routeTableId: zio.aws.fms.model.ActionTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.EC2ReplaceRouteAction = {
    import EC2ReplaceRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.EC2ReplaceRouteAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        destinationCidrBlock.map(value => CIDR.unwrap(value): java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value =>
          CIDR.unwrap(value): java.lang.String
        )
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(gatewayId.map(value => value.buildAwsValue()))(
        _.gatewayId
      )
      .routeTableId(routeTableId.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.fms.model.EC2ReplaceRouteAction.ReadOnly =
    zio.aws.fms.model.EC2ReplaceRouteAction.wrap(buildAwsValue())
}
object EC2ReplaceRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.EC2ReplaceRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.EC2ReplaceRouteAction =
      zio.aws.fms.model.EC2ReplaceRouteAction(
        description.map(value => value),
        destinationCidrBlock.map(value => value),
        destinationPrefixListId.map(value => value),
        destinationIpv6CidrBlock.map(value => value),
        gatewayId.map(value => value.asEditable),
        routeTableId.asEditable
      )
    def description: Option[LengthBoundedString]
    def destinationCidrBlock: Option[CIDR]
    def destinationPrefixListId: Option[ResourceId]
    def destinationIpv6CidrBlock: Option[CIDR]
    def gatewayId: Option[zio.aws.fms.model.ActionTarget.ReadOnly]
    def routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationCidrBlock: ZIO[Any, AwsError, CIDR] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("destinationPrefixListId", destinationPrefixListId)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, CIDR] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getGatewayId
        : ZIO[Any, AwsError, zio.aws.fms.model.ActionTarget.ReadOnly] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getRouteTableId
        : ZIO[Any, Nothing, zio.aws.fms.model.ActionTarget.ReadOnly] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.EC2ReplaceRouteAction
  ) extends zio.aws.fms.model.EC2ReplaceRouteAction.ReadOnly {
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val destinationCidrBlock: Option[CIDR] = scala
      .Option(impl.destinationCidrBlock())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val destinationPrefixListId: Option[ResourceId] = scala
      .Option(impl.destinationPrefixListId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val destinationIpv6CidrBlock: Option[CIDR] = scala
      .Option(impl.destinationIpv6CidrBlock())
      .map(value => zio.aws.fms.model.primitives.CIDR(value))
    override val gatewayId: Option[zio.aws.fms.model.ActionTarget.ReadOnly] =
      scala
        .Option(impl.gatewayId())
        .map(value => zio.aws.fms.model.ActionTarget.wrap(value))
    override val routeTableId: zio.aws.fms.model.ActionTarget.ReadOnly =
      zio.aws.fms.model.ActionTarget.wrap(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.EC2ReplaceRouteAction
  ): zio.aws.fms.model.EC2ReplaceRouteAction.ReadOnly = new Wrapper(impl)
}
