package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ManagedServiceData, LengthBoundedString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FMSPolicyUpdateFirewallCreationConfigAction(
    description: Option[LengthBoundedString] = None,
    firewallCreationConfig: Option[ManagedServiceData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.FMSPolicyUpdateFirewallCreationConfigAction = {
    import FMSPolicyUpdateFirewallCreationConfigAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.FMSPolicyUpdateFirewallCreationConfigAction
      .builder()
      .optionallyWith(
        description.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        firewallCreationConfig.map(value =>
          ManagedServiceData.unwrap(value): java.lang.String
        )
      )(_.firewallCreationConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.FMSPolicyUpdateFirewallCreationConfigAction.ReadOnly =
    zio.aws.fms.model.FMSPolicyUpdateFirewallCreationConfigAction
      .wrap(buildAwsValue())
}
object FMSPolicyUpdateFirewallCreationConfigAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.FMSPolicyUpdateFirewallCreationConfigAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.FMSPolicyUpdateFirewallCreationConfigAction =
      zio.aws.fms.model.FMSPolicyUpdateFirewallCreationConfigAction(
        description.map(value => value),
        firewallCreationConfig.map(value => value)
      )
    def description: Option[LengthBoundedString]
    def firewallCreationConfig: Option[ManagedServiceData]
    def getDescription: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallCreationConfig: ZIO[Any, AwsError, ManagedServiceData] =
      AwsError.unwrapOptionField(
        "firewallCreationConfig",
        firewallCreationConfig
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.FMSPolicyUpdateFirewallCreationConfigAction
  ) extends zio.aws.fms.model.FMSPolicyUpdateFirewallCreationConfigAction.ReadOnly {
    override val description: Option[LengthBoundedString] = scala
      .Option(impl.description())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val firewallCreationConfig: Option[ManagedServiceData] = scala
      .Option(impl.firewallCreationConfig())
      .map(value => zio.aws.fms.model.primitives.ManagedServiceData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.FMSPolicyUpdateFirewallCreationConfigAction
  ): zio.aws.fms.model.FMSPolicyUpdateFirewallCreationConfigAction.ReadOnly =
    new Wrapper(impl)
}
