package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{LengthBoundedString, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FirewallSubnetIsOutOfScopeViolation(
    firewallSubnetId: Option[ResourceId] = None,
    vpcId: Option[ResourceId] = None,
    subnetAvailabilityZone: Option[LengthBoundedString] = None,
    subnetAvailabilityZoneId: Option[LengthBoundedString] = None,
    vpcEndpointId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.FirewallSubnetIsOutOfScopeViolation = {
    import FirewallSubnetIsOutOfScopeViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.FirewallSubnetIsOutOfScopeViolation
      .builder()
      .optionallyWith(
        firewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.firewallSubnetId)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetAvailabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZone)
      .optionallyWith(
        subnetAvailabilityZoneId.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.subnetAvailabilityZoneId)
      .optionallyWith(
        vpcEndpointId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcEndpointId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.ReadOnly =
    zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.wrap(buildAwsValue())
}
object FirewallSubnetIsOutOfScopeViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.FirewallSubnetIsOutOfScopeViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation =
      zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation(
        firewallSubnetId.map(value => value),
        vpcId.map(value => value),
        subnetAvailabilityZone.map(value => value),
        subnetAvailabilityZoneId.map(value => value),
        vpcEndpointId.map(value => value)
      )
    def firewallSubnetId: Option[ResourceId]
    def vpcId: Option[ResourceId]
    def subnetAvailabilityZone: Option[LengthBoundedString]
    def subnetAvailabilityZoneId: Option[LengthBoundedString]
    def vpcEndpointId: Option[ResourceId]
    def getFirewallSubnetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("firewallSubnetId", firewallSubnetId)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetAvailabilityZoneId: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZoneId",
        subnetAvailabilityZoneId
      )
    def getVpcEndpointId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.FirewallSubnetIsOutOfScopeViolation
  ) extends zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.ReadOnly {
    override val firewallSubnetId: Option[ResourceId] = scala
      .Option(impl.firewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val subnetAvailabilityZone: Option[LengthBoundedString] = scala
      .Option(impl.subnetAvailabilityZone())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val subnetAvailabilityZoneId: Option[LengthBoundedString] = scala
      .Option(impl.subnetAvailabilityZoneId())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val vpcEndpointId: Option[ResourceId] = scala
      .Option(impl.vpcEndpointId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.FirewallSubnetIsOutOfScopeViolation
  ): zio.aws.fms.model.FirewallSubnetIsOutOfScopeViolation.ReadOnly =
    new Wrapper(impl)
}
