package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.AWSAccountId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAdminAccountResponse(
    adminAccount: Option[AWSAccountId] = None,
    roleStatus: Option[zio.aws.fms.model.AccountRoleStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetAdminAccountResponse = {
    import GetAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetAdminAccountResponse
      .builder()
      .optionallyWith(
        adminAccount.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.adminAccount)
      .optionallyWith(roleStatus.map(value => value.unwrap))(_.roleStatus)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetAdminAccountResponse.ReadOnly =
    zio.aws.fms.model.GetAdminAccountResponse.wrap(buildAwsValue())
}
object GetAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetAdminAccountResponse =
      zio.aws.fms.model.GetAdminAccountResponse(
        adminAccount.map(value => value),
        roleStatus.map(value => value)
      )
    def adminAccount: Option[AWSAccountId]
    def roleStatus: Option[zio.aws.fms.model.AccountRoleStatus]
    def getAdminAccount: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("adminAccount", adminAccount)
    def getRoleStatus: ZIO[Any, AwsError, zio.aws.fms.model.AccountRoleStatus] =
      AwsError.unwrapOptionField("roleStatus", roleStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetAdminAccountResponse
  ) extends zio.aws.fms.model.GetAdminAccountResponse.ReadOnly {
    override val adminAccount: Option[AWSAccountId] = scala
      .Option(impl.adminAccount())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val roleStatus: Option[zio.aws.fms.model.AccountRoleStatus] = scala
      .Option(impl.roleStatus())
      .map(value => zio.aws.fms.model.AccountRoleStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetAdminAccountResponse
  ): zio.aws.fms.model.GetAdminAccountResponse.ReadOnly = new Wrapper(impl)
}
