package zio.aws.fms.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fms.model.primitives.{
  PaginationMaxResults,
  AWSAccountId,
  PaginationToken,
  TimeStamp,
  PolicyId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetProtectionStatusRequest(
    policyId: PolicyId,
    memberAccountId: Option[AWSAccountId] = None,
    startTime: Option[TimeStamp] = None,
    endTime: Option[TimeStamp] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PaginationMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest = {
    import GetProtectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .optionallyWith(startTime.map(value => TimeStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TimeStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.GetProtectionStatusRequest.ReadOnly =
    zio.aws.fms.model.GetProtectionStatusRequest.wrap(buildAwsValue())
}
object GetProtectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.GetProtectionStatusRequest =
      zio.aws.fms.model.GetProtectionStatusRequest(
        policyId,
        memberAccountId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def policyId: PolicyId
    def memberAccountId: Option[AWSAccountId]
    def startTime: Option[TimeStamp]
    def endTime: Option[TimeStamp]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PaginationMaxResults]
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getStartTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
  ) extends zio.aws.fms.model.GetProtectionStatusRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.fms.model.primitives.PolicyId(impl.policyId())
    override val memberAccountId: Option[AWSAccountId] = scala
      .Option(impl.memberAccountId())
      .map(value => zio.aws.fms.model.primitives.AWSAccountId(value))
    override val startTime: Option[TimeStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val endTime: Option[TimeStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.fms.model.primitives.TimeStamp(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: Option[PaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fms.model.primitives.PaginationMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest
  ): zio.aws.fms.model.GetProtectionStatusRequest.ReadOnly = new Wrapper(impl)
}
