package zio.aws.fms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.fms.model.primitives.{PaginationMaxResults, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMemberAccountsRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PaginationMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest = {
    import ListMemberAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListMemberAccountsRequest.ReadOnly =
    zio.aws.fms.model.ListMemberAccountsRequest.wrap(buildAwsValue())
}
object ListMemberAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListMemberAccountsRequest =
      zio.aws.fms.model.ListMemberAccountsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest
  ) extends zio.aws.fms.model.ListMemberAccountsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: Option[PaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fms.model.primitives.PaginationMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest
  ): zio.aws.fms.model.ListMemberAccountsRequest.ReadOnly = new Wrapper(impl)
}
