package zio.aws.fms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.fms.model.primitives.{PaginationMaxResults, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPoliciesRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PaginationMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListPoliciesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => PaginationMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListPoliciesRequest.ReadOnly =
    zio.aws.fms.model.ListPoliciesRequest.wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListPoliciesRequest =
      zio.aws.fms.model.ListPoliciesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PaginationMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PaginationMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesRequest
  ) extends zio.aws.fms.model.ListPoliciesRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
    override val maxResults: Option[PaginationMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.fms.model.primitives.PaginationMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListPoliciesRequest
  ): zio.aws.fms.model.ListPoliciesRequest.ReadOnly = new Wrapper(impl)
}
