package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListProtocolsListsResponse(
    protocolsLists: Option[
      Iterable[zio.aws.fms.model.ProtocolsListDataSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse = {
    import ListProtocolsListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
      .builder()
      .optionallyWith(
        protocolsLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.protocolsLists)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly =
    zio.aws.fms.model.ListProtocolsListsResponse.wrap(buildAwsValue())
}
object ListProtocolsListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.ListProtocolsListsResponse =
      zio.aws.fms.model.ListProtocolsListsResponse(
        protocolsLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def protocolsLists
        : Option[List[zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getProtocolsLists: ZIO[Any, AwsError, List[
      zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("protocolsLists", protocolsLists)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
  ) extends zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly {
    override val protocolsLists
        : Option[List[zio.aws.fms.model.ProtocolsListDataSummary.ReadOnly]] =
      scala
        .Option(impl.protocolsLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fms.model.ProtocolsListDataSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.fms.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.ListProtocolsListsResponse
  ): zio.aws.fms.model.ListProtocolsListsResponse.ReadOnly = new Wrapper(impl)
}
