package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.ResourceId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallInvalidRouteConfigurationViolation(
    affectedSubnets: Option[Iterable[ResourceId]] = None,
    routeTableId: Option[ResourceId] = None,
    isRouteTableUsedInDifferentAZ: Option[Boolean] = None,
    violatingRoute: Option[zio.aws.fms.model.Route] = None,
    currentFirewallSubnetRouteTable: Option[ResourceId] = None,
    expectedFirewallEndpoint: Option[ResourceId] = None,
    actualFirewallEndpoint: Option[ResourceId] = None,
    expectedFirewallSubnetId: Option[ResourceId] = None,
    actualFirewallSubnetId: Option[ResourceId] = None,
    expectedFirewallSubnetRoutes: Option[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = None,
    actualFirewallSubnetRoutes: Option[Iterable[zio.aws.fms.model.Route]] =
      None,
    internetGatewayId: Option[ResourceId] = None,
    currentInternetGatewayRouteTable: Option[ResourceId] = None,
    expectedInternetGatewayRoutes: Option[
      Iterable[zio.aws.fms.model.ExpectedRoute]
    ] = None,
    actualInternetGatewayRoutes: Option[Iterable[zio.aws.fms.model.Route]] =
      None,
    vpcId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation = {
    import NetworkFirewallInvalidRouteConfigurationViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
      .builder()
      .optionallyWith(
        affectedSubnets.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.affectedSubnets)
      .optionallyWith(
        routeTableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.routeTableId)
      .optionallyWith(
        isRouteTableUsedInDifferentAZ.map(value => value: java.lang.Boolean)
      )(_.isRouteTableUsedInDifferentAZ)
      .optionallyWith(violatingRoute.map(value => value.buildAwsValue()))(
        _.violatingRoute
      )
      .optionallyWith(
        currentFirewallSubnetRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentFirewallSubnetRouteTable)
      .optionallyWith(
        expectedFirewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedFirewallEndpoint)
      .optionallyWith(
        actualFirewallEndpoint.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.actualFirewallEndpoint)
      .optionallyWith(
        expectedFirewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.expectedFirewallSubnetId)
      .optionallyWith(
        actualFirewallSubnetId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.actualFirewallSubnetId)
      .optionallyWith(
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedFirewallSubnetRoutes)
      .optionallyWith(
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualFirewallSubnetRoutes)
      .optionallyWith(
        internetGatewayId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.internetGatewayId)
      .optionallyWith(
        currentInternetGatewayRouteTable.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.currentInternetGatewayRouteTable)
      .optionallyWith(
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedInternetGatewayRoutes)
      .optionallyWith(
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actualInternetGatewayRoutes)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallInvalidRouteConfigurationViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation =
      zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation(
        affectedSubnets.map(value => value),
        routeTableId.map(value => value),
        isRouteTableUsedInDifferentAZ.map(value => value),
        violatingRoute.map(value => value.asEditable),
        currentFirewallSubnetRouteTable.map(value => value),
        expectedFirewallEndpoint.map(value => value),
        actualFirewallEndpoint.map(value => value),
        expectedFirewallSubnetId.map(value => value),
        actualFirewallSubnetId.map(value => value),
        expectedFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualFirewallSubnetRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        currentInternetGatewayRouteTable.map(value => value),
        expectedInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actualInternetGatewayRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def affectedSubnets: Option[List[ResourceId]]
    def routeTableId: Option[ResourceId]
    def isRouteTableUsedInDifferentAZ: Option[Boolean]
    def violatingRoute: Option[zio.aws.fms.model.Route.ReadOnly]
    def currentFirewallSubnetRouteTable: Option[ResourceId]
    def expectedFirewallEndpoint: Option[ResourceId]
    def actualFirewallEndpoint: Option[ResourceId]
    def expectedFirewallSubnetId: Option[ResourceId]
    def actualFirewallSubnetId: Option[ResourceId]
    def expectedFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def internetGatewayId: Option[ResourceId]
    def currentInternetGatewayRouteTable: Option[ResourceId]
    def expectedInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def actualInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]]
    def vpcId: Option[ResourceId]
    def getAffectedSubnets: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("affectedSubnets", affectedSubnets)
    def getRouteTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getIsRouteTableUsedInDifferentAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isRouteTableUsedInDifferentAZ",
        isRouteTableUsedInDifferentAZ
      )
    def getViolatingRoute
        : ZIO[Any, AwsError, zio.aws.fms.model.Route.ReadOnly] =
      AwsError.unwrapOptionField("violatingRoute", violatingRoute)
    def getCurrentFirewallSubnetRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentFirewallSubnetRouteTable",
        currentFirewallSubnetRouteTable
      )
    def getExpectedFirewallEndpoint: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("expectedFirewallEndpoint", expectedFirewallEndpoint)
    def getActualFirewallEndpoint: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("actualFirewallEndpoint", actualFirewallEndpoint)
    def getExpectedFirewallSubnetId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("expectedFirewallSubnetId", expectedFirewallSubnetId)
    def getActualFirewallSubnetId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("actualFirewallSubnetId", actualFirewallSubnetId)
    def getExpectedFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedFirewallSubnetRoutes",
        expectedFirewallSubnetRoutes
      )
    def getActualFirewallSubnetRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualFirewallSubnetRoutes",
        actualFirewallSubnetRoutes
      )
    def getInternetGatewayId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getCurrentInternetGatewayRouteTable: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField(
        "currentInternetGatewayRouteTable",
        currentInternetGatewayRouteTable
      )
    def getExpectedInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField(
        "expectedInternetGatewayRoutes",
        expectedInternetGatewayRoutes
      )
    def getActualInternetGatewayRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.Route.ReadOnly]] =
      AwsError.unwrapOptionField(
        "actualInternetGatewayRoutes",
        actualInternetGatewayRoutes
      )
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
  ) extends zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly {
    override val affectedSubnets: Option[List[ResourceId]] = scala
      .Option(impl.affectedSubnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.primitives.ResourceId(item)
        }.toList
      )
    override val routeTableId: Option[ResourceId] = scala
      .Option(impl.routeTableId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val isRouteTableUsedInDifferentAZ: Option[Boolean] = scala
      .Option(impl.isRouteTableUsedInDifferentAZ())
      .map(value => value: Boolean)
    override val violatingRoute: Option[zio.aws.fms.model.Route.ReadOnly] =
      scala
        .Option(impl.violatingRoute())
        .map(value => zio.aws.fms.model.Route.wrap(value))
    override val currentFirewallSubnetRouteTable: Option[ResourceId] = scala
      .Option(impl.currentFirewallSubnetRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallEndpoint: Option[ResourceId] = scala
      .Option(impl.expectedFirewallEndpoint())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val actualFirewallEndpoint: Option[ResourceId] = scala
      .Option(impl.actualFirewallEndpoint())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallSubnetId: Option[ResourceId] = scala
      .Option(impl.expectedFirewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val actualFirewallSubnetId: Option[ResourceId] = scala
      .Option(impl.actualFirewallSubnetId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] = scala
      .Option(impl.expectedFirewallSubnetRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.ExpectedRoute.wrap(item)
        }.toList
      )
    override val actualFirewallSubnetRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.actualFirewallSubnetRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val internetGatewayId: Option[ResourceId] = scala
      .Option(impl.internetGatewayId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val currentInternetGatewayRouteTable: Option[ResourceId] = scala
      .Option(impl.currentInternetGatewayRouteTable())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val expectedInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] = scala
      .Option(impl.expectedInternetGatewayRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.ExpectedRoute.wrap(item)
        }.toList
      )
    override val actualInternetGatewayRoutes
        : Option[List[zio.aws.fms.model.Route.ReadOnly]] = scala
      .Option(impl.actualInternetGatewayRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.Route.wrap(item)
        }.toList
      )
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation
  ): zio.aws.fms.model.NetworkFirewallInvalidRouteConfigurationViolation.ReadOnly =
    new Wrapper(impl)
}
