package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{ResourceId, ViolationTarget}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallMissingExpectedRoutesViolation(
    violationTarget: Option[ViolationTarget] = None,
    expectedRoutes: Option[Iterable[zio.aws.fms.model.ExpectedRoute]] = None,
    vpcId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRoutesViolation = {
    import NetworkFirewallMissingExpectedRoutesViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRoutesViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        expectedRoutes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expectedRoutes)
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallMissingExpectedRoutesViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRoutesViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation =
      zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation(
        violationTarget.map(value => value),
        expectedRoutes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def violationTarget: Option[ViolationTarget]
    def expectedRoutes: Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]]
    def vpcId: Option[ResourceId]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getExpectedRoutes
        : ZIO[Any, AwsError, List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] =
      AwsError.unwrapOptionField("expectedRoutes", expectedRoutes)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRoutesViolation
  ) extends zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val expectedRoutes
        : Option[List[zio.aws.fms.model.ExpectedRoute.ReadOnly]] = scala
      .Option(impl.expectedRoutes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fms.model.ExpectedRoute.wrap(item)
        }.toList
      )
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRoutesViolation
  ): zio.aws.fms.model.NetworkFirewallMissingExpectedRoutesViolation.ReadOnly =
    new Wrapper(impl)
}
