package zio.aws.fms.model
import zio.ZIO
import zio.aws.fms.model.primitives.{
  TargetViolationReason,
  LengthBoundedString,
  ResourceId,
  ViolationTarget
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkFirewallMissingFirewallViolation(
    violationTarget: Option[ViolationTarget] = None,
    vpc: Option[ResourceId] = None,
    availabilityZone: Option[LengthBoundedString] = None,
    targetViolationReason: Option[TargetViolationReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation = {
    import NetworkFirewallMissingFirewallViolation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation
      .builder()
      .optionallyWith(
        violationTarget.map(value =>
          ViolationTarget.unwrap(value): java.lang.String
        )
      )(_.violationTarget)
      .optionallyWith(
        vpc.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpc)
      .optionallyWith(
        availabilityZone.map(value =>
          LengthBoundedString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        targetViolationReason.map(value =>
          TargetViolationReason.unwrap(value): java.lang.String
        )
      )(_.targetViolationReason)
      .build()
  }
  def asReadOnly
      : zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly =
    zio.aws.fms.model.NetworkFirewallMissingFirewallViolation
      .wrap(buildAwsValue())
}
object NetworkFirewallMissingFirewallViolation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fms.model.NetworkFirewallMissingFirewallViolation =
      zio.aws.fms.model.NetworkFirewallMissingFirewallViolation(
        violationTarget.map(value => value),
        vpc.map(value => value),
        availabilityZone.map(value => value),
        targetViolationReason.map(value => value)
      )
    def violationTarget: Option[ViolationTarget]
    def vpc: Option[ResourceId]
    def availabilityZone: Option[LengthBoundedString]
    def targetViolationReason: Option[TargetViolationReason]
    def getViolationTarget: ZIO[Any, AwsError, ViolationTarget] =
      AwsError.unwrapOptionField("violationTarget", violationTarget)
    def getVpc: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getAvailabilityZone: ZIO[Any, AwsError, LengthBoundedString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getTargetViolationReason: ZIO[Any, AwsError, TargetViolationReason] =
      AwsError.unwrapOptionField("targetViolationReason", targetViolationReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation
  ) extends zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly {
    override val violationTarget: Option[ViolationTarget] = scala
      .Option(impl.violationTarget())
      .map(value => zio.aws.fms.model.primitives.ViolationTarget(value))
    override val vpc: Option[ResourceId] = scala
      .Option(impl.vpc())
      .map(value => zio.aws.fms.model.primitives.ResourceId(value))
    override val availabilityZone: Option[LengthBoundedString] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.fms.model.primitives.LengthBoundedString(value))
    override val targetViolationReason: Option[TargetViolationReason] = scala
      .Option(impl.targetViolationReason())
      .map(value => zio.aws.fms.model.primitives.TargetViolationReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation
  ): zio.aws.fms.model.NetworkFirewallMissingFirewallViolation.ReadOnly =
    new Wrapper(impl)
}
